/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.UpdateTest;
import com.openexchange.groupware.update.tasks.CreatePublicationTablesTask;
import java.sql.SQLException;

public class CreatePublishTablesTest
extends UpdateTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        this.execSafe("DROP TABLE publications", new Object[0]);
        this.execSafe("DROP TABLE sequence_publications", new Object[0]);
        super.tearDown();
    }

    public void testShouldCreatePublicationsTable() throws OXException {
        this.executeTask();
        try {
            this.exec("SELECT id, cid, user_id, entity, module, configuration_id, target_id FROM publications", new Object[0]);
        }
        catch (SQLException x) {
            CreatePublishTablesTest.fail((String)("Expected table publications, but doesn't seem to exist: " + x.toString()));
        }
    }

    public void testShouldCreateSequenceTable() throws OXException {
        this.executeTask();
        try {
            this.exec("SELECT cid, id FROM sequence_publications", new Object[0]);
        }
        catch (SQLException x) {
            CreatePublishTablesTest.fail((String)("Expected table sequence_publications, but doesn't seem to exist: " + x.toString()));
        }
    }

    public void testShouldCreateEntryInSequenceTableForEveryContext() throws OXException, SQLException {
        this.executeTask();
        this.assertResult("SELECT 1 FROM sequence_publications WHERE cid = " + this.existing_ctx_id, new Object[0]);
    }

    private void executeTask() throws OXException {
        new CreatePublicationTablesTask().perform(this.schema, this.existing_ctx_id);
    }

    public void testShouldBeRunnableTwice() throws OXException {
        this.executeTask();
        this.executeTask();
    }
}

