/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreSearchEngine;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.infostore.search.impl.SearchEngineImpl;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.test.TestInit;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionFactory;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class SearchEngineTest
extends TestCase {
    private InfostoreSearchEngine searchEngine;
    private Context ctx = null;
    private User user = null;
    private User user2 = null;
    private UserPermissionBits permissionBits = null;
    private UserPermissionBits permissionBits2 = null;
    private int folderId;
    private int folderId2;
    private ServerSession session;
    private ServerSession session2;
    private List<DocumentMetadata> clean;
    private List<FolderObject> cleanFolders = null;
    private DBProvider provider = null;
    private InfostoreFacade infostore = null;

    public void setUp() throws Exception {
        this.clean = new ArrayList<DocumentMetadata>();
        this.cleanFolders = new ArrayList<FolderObject>();
        TestInit.loadTestProperties();
        Init.startServer();
        ContextStorage ctxstor = ContextStorage.getInstance();
        UserPermissionBitsStorage userConfigStorage = UserPermissionBitsStorage.getInstance();
        int contextId = ctxstor.getContextId("defaultcontext");
        this.ctx = ctxstor.getContext(contextId);
        this.user = UserStorage.getInstance().getUser(UserStorage.getInstance().getUserId("thorben", this.ctx), this.ctx);
        this.user2 = UserStorage.getInstance().getUser(UserStorage.getInstance().getUserId("francisco", this.ctx), this.ctx);
        this.session = ServerSessionFactory.createServerSession(this.user.getId(), this.ctx, "blupp");
        this.session2 = ServerSessionFactory.createServerSession(this.user2.getId(), this.ctx, "blupp2");
        this.permissionBits = userConfigStorage.getUserPermissionBits(this.session.getUserId(), this.ctx);
        this.permissionBits2 = userConfigStorage.getUserPermissionBits(this.session2.getUserId(), this.ctx);
        this.folderId = this._getPrivateInfostoreFolder(this.ctx, this.user, this.session);
        this.folderId2 = this._getPrivateInfostoreFolder(this.ctx, this.user2, this.session2);
        this.provider = new DBPoolProvider();
        this.searchEngine = new SearchEngineImpl(this.provider);
        this.infostore = new InfostoreFacadeImpl(this.provider);
    }

    public int _getPrivateInfostoreFolder(Context context, User usr, ServerSession sess) throws OXException {
        OXFolderAccess oxfa = new OXFolderAccess(context);
        return oxfa.getDefaultFolder(usr.getId(), 8).getObjectID();
    }

    public void testRequestedFieldOrderMayVary() {
        this.assertSurvivesOrder(new Metadata[]{Metadata.ID_LITERAL, Metadata.FOLDER_ID_LITERAL, Metadata.TITLE_LITERAL});
        this.assertSurvivesOrder(new Metadata[]{Metadata.FOLDER_ID_LITERAL, Metadata.ID_LITERAL, Metadata.TITLE_LITERAL});
        this.assertSurvivesOrder(new Metadata[]{Metadata.FOLDER_ID_LITERAL, Metadata.TITLE_LITERAL, Metadata.ID_LITERAL});
        this.assertSurvivesOrder(new Metadata[]{Metadata.FOLDER_ID_LITERAL, Metadata.TITLE_LITERAL});
    }

    public void testSearchForPercent() throws OXException, OXException {
        DocumentMetadata doc1 = this.createWithTitle("100%");
        this.createWithTitle("Hallo");
        SearchIterator iter = this.searchEngine.search("%", new Metadata[]{Metadata.ID_LITERAL, Metadata.TITLE_LITERAL}, this.folderId, Metadata.TITLE_LITERAL, 1, 0, 10, this.ctx, this.user, this.permissionBits);
        SearchEngineTest.assertTrue((boolean)iter.hasNext());
        DocumentMetadata gotDoc = (DocumentMetadata)iter.next();
        SearchEngineTest.assertFalse((boolean)iter.hasNext());
        SearchEngineTest.assertEquals((int)doc1.getId(), (int)gotDoc.getId());
    }

    private DocumentMetadata createWithTitle(String title) throws OXException {
        DocumentMetadataImpl metadata = new DocumentMetadataImpl();
        metadata.setTitle(title);
        metadata.setFolderId((long)this.folderId);
        try {
            this.infostore.startTransaction();
            this.infostore.saveDocumentMetadata((DocumentMetadata)metadata, -1L, this.session);
            this.infostore.commit();
            this.clean.add((DocumentMetadata)metadata);
        }
        catch (OXException x) {
            try {
                this.infostore.rollback();
            }
            catch (OXException e) {
                e.printStackTrace();
            }
            throw x;
        }
        finally {
            try {
                this.infostore.finish();
            }
            catch (OXException e) {
                e.printStackTrace();
            }
        }
        return metadata;
    }

    private void assertSurvivesOrder(Metadata[] metadata) {
        try {
            this.searchEngine.search("*", metadata, this.folderId, metadata[0], 1, 0, 10, this.ctx, this.user, this.permissionBits);
        }
        catch (Exception x) {
            SearchEngineTest.fail((String)x.getMessage());
            x.printStackTrace();
        }
    }
}

