/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware;

import com.openexchange.calendar.api.CalendarCollection;
import com.openexchange.event.impl.EventConfigImpl;
import com.openexchange.groupware.CalendarTest;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.test.AjaxInit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import junit.framework.TestCase;

public class CalendarPerformanceTests
extends TestCase {
    public static final long SUPER_END = 253402210800000L;
    public static final String TIMEZONE = "Europe/Berlin";
    private static int userid = 11;
    public static int contextid = 1;
    private static boolean init = false;
    private static final String testfile = "/home/bishoph/tmp/supertemp/sqloutput";

    protected void setUp() throws Exception {
        super.setUp();
        Init.startServer();
        init = true;
        EventConfigImpl event = new EventConfigImpl();
        event.setEventQueueEnabled(false);
        contextid = ContextStorage.getInstance().getContextId("defaultcontext");
        userid = CalendarPerformanceTests.getUserId();
        ContextStorage.start();
    }

    protected void tearDown() throws Exception {
        if (init) {
            init = false;
            Init.stopServer();
        }
        super.tearDown();
    }

    private static Properties getAJAXProperties() {
        Properties properties = AjaxInit.getAJAXProperties();
        return properties;
    }

    private static int resolveUser(String u) throws Exception {
        UserStorage uStorage = UserStorage.getInstance();
        return uStorage.getUserId(u, CalendarPerformanceTests.getContext());
    }

    public static int getUserId() throws Exception {
        if (!init) {
            Init.startServer();
            init = true;
        }
        String user = CalendarPerformanceTests.getAJAXProperties().getProperty("user_participant2", "");
        return CalendarPerformanceTests.resolveUser(user);
    }

    public static Context getContext() {
        return new ContextImpl(contextid);
    }

    public static int getPrivateFolder() throws Exception {
        int privatefolder = 0;
        Context context = CalendarPerformanceTests.getContext();
        privatefolder = CalendarTest.getCalendarDefaultFolderForUser(userid, context);
        return privatefolder;
    }

    public void testSimple() throws Throwable {
        File f = new File(testfile);
        CalendarPerformanceTests.calc(f, 0);
    }

    public void testThreaded() throws Throwable {
        Runner[] runner = new Runner[100];
        Thread[] thread = new Thread[runner.length];
        for (int a = 0; a < runner.length; ++a) {
            runner[a] = new Runner(a);
            thread[a] = new Thread(runner[a]);
            thread[a].start();
        }
        for (int b = 0; b < thread.length; ++b) {
            thread[b].join();
        }
    }

    public static void calc(File f, int number) throws Throwable {
        String line;
        BufferedReader r = new BufferedReader(new FileReader(f));
        LineNumberReader lnr = new LineNumberReader(r);
        long all = 0L;
        long high = 0L;
        HashMap<String, Integer> count_cid = new HashMap<String, Integer>();
        while ((line = lnr.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            if (st.countTokens() != 8) continue;
            String startdate = st.nextToken();
            String starttime = st.nextToken();
            String enddate = st.nextToken();
            String endtime = st.nextToken();
            String cid = st.nextToken();
            if (count_cid.containsKey(cid)) {
                int cid_count = (Integer)count_cid.get(cid);
                count_cid.put(cid, ++cid_count);
            } else {
                count_cid.put(cid, 1);
            }
            String recstring = st.nextToken();
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date sdate = dateformat.parse(startdate + " " + starttime);
            Date edate = dateformat.parse(enddate + " " + endtime);
            long start = System.currentTimeMillis();
            CalendarDataObject cdao = new CalendarDataObject();
            cdao.setTimezone(TIMEZONE);
            cdao.setTitle("Daily Appointment Test");
            cdao.setRecurrence(recstring);
            cdao.setStartDate(sdate);
            cdao.setEndDate(edate);
            new CalendarCollection().fillDAO(cdao);
            new CalendarCollection().calculateRecurring((CalendarObject)cdao, 0L, 5709135600000L, 0);
            long end = System.currentTimeMillis();
            long duration = end - start;
            all += duration;
            if (duration <= high) continue;
            high = duration;
        }
        Iterator it = count_cid.keySet().iterator();
        int hit = 0;
        while (it.hasNext()) {
            String key = (String)it.next();
            int check = (Integer)count_cid.get(key);
            if (check <= hit) continue;
            hit = check;
        }
    }

    private class Runner
    implements Runnable {
        int current;
        boolean run = true;

        public Runner(int current) {
            this.current = current;
        }

        @Override
        public void run() {
            while (this.run) {
                File f = new File(CalendarPerformanceTests.testfile);
                try {
                    CalendarPerformanceTests.calc(f, this.current);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

