/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import java.util.Date;

public class Bug31453Test
extends CalDAVTest {
    private FolderObject publicFolder = null;
    private String publicFolderID = null;

    public Bug31453Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.publicFolder = this.createPublicFolder();
        this.publicFolderID = String.valueOf(this.publicFolder.getObjectID());
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreateReminderInClient() throws Exception {
        String uid = Bug31453Test.randomUID();
        Date start = TimeTools.D("next sunday at 14:15");
        Date end = TimeTools.D("next sunday at 15:30");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nMETHOD:REQUEST\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.2//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:CEST\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:CET\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTEND;TZID=Europe/Berlin:" + Bug31453Test.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug31453Test.formatAsUTC(new Date()) + "\r\n" + "LOCATION:loc" + "\r\n" + "DESCRIPTION:stripped" + "\r\n" + "SEQUENCE:2" + "\r\n" + "SUMMARY:test" + "\r\n" + "BEGIN:VALARM" + "\r\n" + "X-WR-ALARMUID:" + uid + "\r\n" + "UID:" + uid + "\r\n" + "TRIGGER:-PT15M" + "\r\n" + "DESCRIPTION:Ereignisbenachrichtigung" + "\r\n" + "ACTION:DISPLAY" + "\r\n" + "END:VALARM" + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug31453Test.format(start, "Europe/Berlin") + "\r\n" + "CREATED:" + Bug31453Test.formatAsUTC(TimeTools.D("yesterday noon")) + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Bug31453Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICal(this.publicFolderID, uid, iCal));
        Appointment appointment = super.getAppointment(this.publicFolderID, uid);
        Bug31453Test.assertNotNull((String)"appointment not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        Bug31453Test.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Bug31453Test.assertEquals((String)"reminder minuteswrong", (int)15, (int)appointment.getAlarm());
        ICalResource iCalResource = super.get(this.publicFolderID, uid, null);
        Bug31453Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug31453Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug31453Test.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Bug31453Test.assertEquals((String)"ALARM wrong", (String)"-PT15M", (String)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
    }

    public void testRemoveReminderInClient() throws Exception {
        String uid = Bug31453Test.randomUID();
        Date start = TimeTools.D("next sunday at 14:15");
        Date end = TimeTools.D("next sunday at 15:30");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nMETHOD:REQUEST\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.2//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:CEST\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:CET\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTEND;TZID=Europe/Berlin:" + Bug31453Test.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug31453Test.formatAsUTC(new Date()) + "\r\n" + "LOCATION:loc" + "\r\n" + "DESCRIPTION:stripped" + "\r\n" + "SEQUENCE:2" + "\r\n" + "SUMMARY:test" + "\r\n" + "BEGIN:VALARM" + "\r\n" + "X-WR-ALARMUID:" + uid + "\r\n" + "UID:" + uid + "\r\n" + "TRIGGER:-PT15M" + "\r\n" + "DESCRIPTION:Ereignisbenachrichtigung" + "\r\n" + "ACTION:DISPLAY" + "\r\n" + "END:VALARM" + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug31453Test.format(start, "Europe/Berlin") + "\r\n" + "CREATED:" + Bug31453Test.formatAsUTC(TimeTools.D("yesterday noon")) + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Bug31453Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICal(this.publicFolderID, uid, iCal));
        Appointment appointment = super.getAppointment(this.publicFolderID, uid);
        Bug31453Test.assertNotNull((String)"appointment not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        Bug31453Test.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Bug31453Test.assertEquals((String)"reminder minutes wrong", (int)15, (int)appointment.getAlarm());
        ICalResource iCalResource = super.get(this.publicFolderID, uid, null);
        Bug31453Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug31453Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug31453Test.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Bug31453Test.assertEquals((String)"ALARM wrong", (String)"-PT15M", (String)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        SimpleICal.Component vAlarm = iCalResource.getVEvent().getVAlarm();
        iCalResource.getVEvent().getComponents().remove(vAlarm);
        Bug31453Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(this.publicFolderID, uid);
        Bug31453Test.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Bug31453Test.assertFalse((String)"reminder found", (boolean)appointment.containsAlarm());
        Bug31453Test.assertEquals((String)"reminder minutes wrong", (int)0, (int)appointment.getAlarm());
        iCalResource = super.get(this.publicFolderID, uid, iCalResource.getETag());
        Bug31453Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug31453Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug31453Test.assertNull((String)"ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
    }

    public void testEditReminderInClient() throws Exception {
        String uid = Bug31453Test.randomUID();
        Date start = TimeTools.D("next sunday at 14:15");
        Date end = TimeTools.D("next sunday at 15:30");
        String iCal = "BEGIN:VCALENDAR\r\nVERSION:2.0\r\nMETHOD:REQUEST\r\nPRODID:-//Apple Inc.//Mac OS X 10.8.2//EN\r\nCALSCALE:GREGORIAN\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nDTSTART:19810329T020000\r\nTZNAME:CEST\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nDTSTART:19961027T030000\r\nTZNAME:CET\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTEND;TZID=Europe/Berlin:" + Bug31453Test.format(end, "Europe/Berlin") + "\r\n" + "TRANSP:OPAQUE" + "\r\n" + "UID:" + uid + "\r\n" + "DTSTAMP:" + Bug31453Test.formatAsUTC(new Date()) + "\r\n" + "LOCATION:loc" + "\r\n" + "DESCRIPTION:stripped" + "\r\n" + "SEQUENCE:2" + "\r\n" + "SUMMARY:test" + "\r\n" + "BEGIN:VALARM" + "\r\n" + "X-WR-ALARMUID:" + uid + "\r\n" + "UID:" + uid + "\r\n" + "TRIGGER:-PT15M" + "\r\n" + "DESCRIPTION:Ereignisbenachrichtigung" + "\r\n" + "ACTION:DISPLAY" + "\r\n" + "END:VALARM" + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug31453Test.format(start, "Europe/Berlin") + "\r\n" + "CREATED:" + Bug31453Test.formatAsUTC(TimeTools.D("yesterday noon")) + "\r\n" + "END:VEVENT" + "\r\n" + "END:VCALENDAR";
        Bug31453Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICal(this.publicFolderID, uid, iCal));
        Appointment appointment = super.getAppointment(this.publicFolderID, uid);
        Bug31453Test.assertNotNull((String)"appointment not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        Bug31453Test.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Bug31453Test.assertEquals((String)"reminder minutes wrong", (int)15, (int)appointment.getAlarm());
        ICalResource iCalResource = super.get(this.publicFolderID, uid, null);
        Bug31453Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug31453Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug31453Test.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Bug31453Test.assertEquals((String)"ALARM wrong", (String)"-PT15M", (String)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        iCalResource.getVEvent().getVAlarm().setProperty("TRIGGER", "-PT20M");
        Bug31453Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(this.publicFolderID, uid);
        Bug31453Test.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Bug31453Test.assertTrue((String)"no reminder found", (boolean)appointment.containsAlarm());
        Bug31453Test.assertEquals((String)"reminder minutes wrong", (int)20, (int)appointment.getAlarm());
        iCalResource = super.get(this.publicFolderID, uid, iCalResource.getETag());
        Bug31453Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug31453Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug31453Test.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Bug31453Test.assertEquals((String)"ALARM wrong", (String)"-PT20M", (String)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
    }

    public void testCreateReminderAtServer() throws Exception {
        String uid = Bug31453Test.randomUID();
        Date start = TimeTools.D("next friday at 08:50");
        Date end = TimeTools.D("next friday at 09:20");
        Appointment appointment = Bug31453Test.generateAppointment(start, end, uid, "test", "test");
        appointment.setAlarm(30);
        appointment = this.create(this.publicFolderID, appointment);
        ICalResource iCalResource = super.get(String.valueOf(this.publicFolder.getObjectID()), uid, null);
        Bug31453Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug31453Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug31453Test.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Bug31453Test.assertEquals((String)"ALARM wrong", (String)"-PT30M", (String)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
    }

    public void testRemoveReminderAtServer() throws Exception {
        String uid = Bug31453Test.randomUID();
        Date start = TimeTools.D("next friday at 08:50");
        Date end = TimeTools.D("next friday at 09:20");
        Appointment appointment = Bug31453Test.generateAppointment(start, end, uid, "test", "test");
        appointment.setAlarm(30);
        appointment = this.create(this.publicFolderID, appointment);
        ICalResource iCalResource = super.get(String.valueOf(this.publicFolder.getObjectID()), uid, null);
        Bug31453Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug31453Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug31453Test.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Bug31453Test.assertEquals((String)"ALARM wrong", (String)"-PT30M", (String)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        appointment.setAlarm(-1);
        super.update(appointment);
        iCalResource = super.get(this.publicFolderID, uid, iCalResource.getETag());
        Bug31453Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug31453Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug31453Test.assertNull((String)"ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
    }

    public void testEditReminderAtServer() throws Exception {
        String uid = Bug31453Test.randomUID();
        Date start = TimeTools.D("next friday at 08:50");
        Date end = TimeTools.D("next friday at 09:20");
        Appointment appointment = Bug31453Test.generateAppointment(start, end, uid, "test", "test");
        appointment.setAlarm(30);
        appointment = this.create(this.publicFolderID, appointment);
        ICalResource iCalResource = super.get(String.valueOf(this.publicFolder.getObjectID()), uid, null);
        Bug31453Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug31453Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug31453Test.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Bug31453Test.assertEquals((String)"ALARM wrong", (String)"-PT30M", (String)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
        appointment.setAlarm(20);
        super.update(appointment);
        iCalResource = super.get(this.publicFolderID, uid, iCalResource.getETag());
        Bug31453Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug31453Test.assertNotNull((String)"No ALARM in iCal found", (Object)iCalResource.getVEvent().getVAlarm());
        Bug31453Test.assertEquals((String)"ALARM wrong", (String)"-PT20M", (String)iCalResource.getVEvent().getVAlarm().getPropertyValue("TRIGGER"));
    }
}

