/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;

public class Bug27309Test
extends CalDAVTest {
    public Bug27309Test(String name) {
        super(name);
    }

    public void testChangeToDaily() throws Exception {
        String uid = Bug27309Test.randomUID();
        Appointment appointment = new Appointment();
        appointment.setUid(uid);
        appointment.setTitle(((Object)((Object)this)).getClass().getCanonicalName());
        appointment.setIgnoreConflicts(true);
        appointment.setStartDate(TimeTools.D("next monday at 17:00"));
        appointment.setEndDate(TimeTools.D("next monday at 18:00"));
        appointment.setRecurrenceType(2);
        appointment.setDays(2);
        appointment.setInterval(1);
        super.create(appointment);
        super.rememberForCleanUp(appointment);
        ICalResource iCalResource = super.get(uid, null);
        Bug27309Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug27309Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        iCalResource.getVEvent().setProperty("RRULE", "FREQ=DAILY;INTERVAL=1;COUNT=3");
        Bug27309Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(uid);
        Bug27309Test.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Bug27309Test.assertEquals((String)"recurrence type wrong", (int)1, (int)appointment.getRecurrenceType());
        Bug27309Test.assertEquals((String)"interval wrong", (int)1, (int)appointment.getInterval());
        Bug27309Test.assertEquals((String)"recurrence count wrong", (int)3, (int)appointment.getOccurrence());
    }
}

