/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Bug23610Test
extends CalDAVTest {
    public Bug23610Test(String name) {
        super(name);
    }

    public void testConfirmAppointment() throws Exception {
        for (int shownAs : new int[]{4, 2, 1, 3}) {
            for (int confirmation : new int[]{1, 2, 3}) {
                this.confirmAppointment(shownAs, confirmation);
            }
        }
    }

    private void confirmAppointment(int appointmentShownAs, int confirmationStatus) throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String uid = Bug23610Test.randomUID();
        String summary = "Bug23610Test-" + appointmentShownAs + "-" + confirmationStatus;
        String location = "test";
        Date start = TimeTools.D("next saturday at 10:00");
        Date end = TimeTools.D("next saturday at 11:00");
        Appointment appointment = Bug23610Test.generateAppointment(start, end, uid, summary, location);
        appointment.setOrganizer("otto@example.com");
        appointment.addParticipant((Participant)new UserParticipant(super.getAJAXClient().getValues().getUserId()));
        ExternalUserParticipant participant = new ExternalUserParticipant("otto@example.com");
        participant.setConfirm(1);
        appointment.addParticipant((Participant)participant);
        appointment.setShownAs(appointmentShownAs);
        super.rememberForCleanUp(super.create(appointment));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Bug23610Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug23610Test.assertContains(uid, calendarData);
        Bug23610Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug23610Test.assertEquals((String)"SUMMARY wrong", (String)summary, (String)iCalResource.getVEvent().getSummary());
        Bug23610Test.assertEquals((String)"LOCATION wrong", (String)location, (String)iCalResource.getVEvent().getLocation());
        if (null != iCalResource.getVEvent().getTransp()) {
            Bug23610Test.assertEquals((String)"TRANSP wrong", (String)(4 == appointmentShownAs ? "TRANSPARENT" : "OPAQUE"), (String)iCalResource.getVEvent().getTransp());
        }
        String partstat = 3 == confirmationStatus ? "TENTATIVE" : (2 == confirmationStatus ? "DECLINED" : "ACCEPTED");
        List<SimpleICal.Property> attendees = iCalResource.getVEvent().getProperties("ATTENDEE");
        for (SimpleICal.Property property : attendees) {
            if (!property.getValue().contains(super.getAJAXClient().getValues().getDefaultAddress())) continue;
            for (Map.Entry<String, String> attribute : property.getAttributes().entrySet()) {
                if (!attribute.getKey().equals("PARTSTAT")) continue;
                attribute.setValue(partstat);
            }
        }
        Bug23610Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(uid);
        Bug23610Test.assertNotNull((String)"appointment not found on server", (Object)appointment);
        UserParticipant[] users = appointment.getUsers();
        Bug23610Test.assertNotNull((String)"appointment has no users", (Object)users);
        UserParticipant partipant = null;
        for (UserParticipant user : users) {
            if (this.getAJAXClient().getValues().getUserId() != user.getIdentifier()) continue;
            partipant = user;
            break;
        }
        Bug23610Test.assertNotNull((String)"confirming participant not found", partipant);
        Bug23610Test.assertEquals((String)"confirmation status wrong", (int)confirmationStatus, (int)partipant.getConfirm());
        Bug23610Test.assertEquals((String)"shown as wrong", (int)appointmentShownAs, (int)appointment.getShownAs());
        iCalResource = super.get(uid, iCalResource.getETag());
        Bug23610Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug23610Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        SimpleICal.Property attendee = null;
        attendees = iCalResource.getVEvent().getProperties("ATTENDEE");
        for (SimpleICal.Property property : attendees) {
            if (!property.getValue().contains(super.getAJAXClient().getValues().getDefaultAddress())) continue;
            attendee = property;
            break;
        }
        Bug23610Test.assertNotNull((String)"confirming attendee not found", attendee);
        Bug23610Test.assertEquals((String)"partstat status wrong", (String)partstat, (String)attendee.getAttribute("PARTSTAT"));
        if (null != iCalResource.getVEvent().getTransp()) {
            Bug23610Test.assertEquals((String)"TRANSP wrong", (String)(4 == appointmentShownAs ? "TRANSPARENT" : "OPAQUE"), (String)iCalResource.getVEvent().getTransp());
        }
    }
}

