/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.xing;

import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.xing.actions.ChangeStatusRequest;
import com.openexchange.ajax.xing.actions.ChangeStatusResponse;
import com.openexchange.ajax.xing.actions.CommentActivityRequest;
import com.openexchange.ajax.xing.actions.CommentActivityResponse;
import com.openexchange.ajax.xing.actions.DeleteActivityRequest;
import com.openexchange.ajax.xing.actions.DeleteActivityResponse;
import com.openexchange.ajax.xing.actions.DeleteCommentRequest;
import com.openexchange.ajax.xing.actions.DeleteCommentResponse;
import com.openexchange.ajax.xing.actions.GetCommentsRequest;
import com.openexchange.ajax.xing.actions.GetCommentsResponse;
import com.openexchange.ajax.xing.actions.GetLikesRequest;
import com.openexchange.ajax.xing.actions.GetLikesResponse;
import com.openexchange.ajax.xing.actions.LikeActivityRequest;
import com.openexchange.ajax.xing.actions.LikeActivityResponse;
import com.openexchange.ajax.xing.actions.ShareActivityRequest;
import com.openexchange.ajax.xing.actions.ShareLinkRequest;
import com.openexchange.ajax.xing.actions.ShareLinkResponse;
import com.openexchange.ajax.xing.actions.ShowActivityRequest;
import com.openexchange.ajax.xing.actions.ShowActivityResponse;
import com.openexchange.ajax.xing.actions.UnlikeActivityRequest;
import com.openexchange.ajax.xing.actions.UnlikeActivityResponse;
import com.openexchange.ajax.xing.actions.UserFeedRequest;
import com.openexchange.exception.OXException;
import com.openexchange.xing.UserField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityTest
extends AbstractAJAXSession {
    private final String XING_OWNER = "dimitribronkowitsch@googlemail.com";

    public ActivityTest(String name) {
        super(name);
    }

    public void testLikesActivity() throws OXException, IOException, JSONException {
        String activityId = this.getActivityIdContainingPermission("LIKE");
        LikeActivityRequest likeRequest = new LikeActivityRequest(activityId, true);
        LikeActivityResponse likeResponse = this.client.execute(likeRequest);
        ActivityTest.assertNotNull((Object)((Object)likeResponse));
        GetLikesRequest getLikesRequest = new GetLikesRequest(activityId, -1, -1, new int[0], true);
        GetLikesResponse getLikesResponse = this.client.execute(getLikesRequest);
        ActivityTest.assertNotNull((Object)((Object)getLikesResponse));
        UnlikeActivityRequest unlikeRequest = new UnlikeActivityRequest(activityId, true);
        UnlikeActivityResponse unlikeResponse = this.client.execute(unlikeRequest);
        ActivityTest.assertNotNull((Object)((Object)unlikeResponse));
    }

    public void testCreateDeleteStatusMessage() throws OXException, IOException, JSONException {
        ChangeStatusRequest createRequest = new ChangeStatusRequest("My new status", true);
        ChangeStatusResponse createResponse = this.client.execute(createRequest);
        ActivityTest.assertNotNull((Object)((Object)createResponse));
        ActivityTest.assertTrue((boolean)((Boolean)createResponse.getData()));
        this.deleteActivity(false);
    }

    public void testShowActivityWithUserFields() throws OXException, IOException, JSONException {
        JSONObject json = (JSONObject)this.client.execute(new UserFeedRequest("dimitribronkowitsch@googlemail.com", -1L, -1L, new int[0], true)).getData();
        ActivityTest.assertNotNull((String)"No activity available", (Object)json.getJSONArray("network_activities").getJSONObject(0));
        String activityId = json.getJSONArray("network_activities").getJSONObject(0).getJSONArray("ids").getString(0);
        int[] uf = new int[]{UserField.FIRST_NAME.ordinal(), UserField.LAST_NAME.ordinal(), UserField.DISPLAY_NAME.ordinal()};
        ShowActivityRequest request = new ShowActivityRequest(activityId, uf, true);
        ShowActivityResponse response = this.client.execute(request);
        ActivityTest.assertNotNull((Object)((Object)response));
        JSONObject jsonResponse = (JSONObject)response.getData();
        ActivityTest.assertNotNull((Object)jsonResponse.get("activities"));
    }

    public void testShowActivity() throws OXException, IOException, JSONException {
        JSONObject json = (JSONObject)this.client.execute(new UserFeedRequest("dimitribronkowitsch@googlemail.com", -1L, -1L, new int[0], true)).getData();
        ActivityTest.assertNotNull((String)"No activity available", (Object)json.getJSONArray("network_activities").getJSONObject(0));
        String activityId = json.getJSONArray("network_activities").getJSONObject(0).getJSONArray("ids").getString(0);
        ShowActivityRequest request = new ShowActivityRequest(activityId, new int[0], true);
        ShowActivityResponse response = this.client.execute(request);
        ActivityTest.assertNotNull((Object)((Object)response));
        JSONObject jsonResponse = (JSONObject)response.getData();
        ActivityTest.assertNotNull((Object)jsonResponse.get("activities"));
    }

    private void deleteActivity() throws OXException, IOException, JSONException {
        this.deleteActivity(true);
    }

    private void deleteActivity(boolean failOnError) throws OXException, IOException, JSONException {
        JSONObject json = (JSONObject)this.client.execute(new UserFeedRequest("dimitribronkowitsch@googlemail.com", -1L, -1L, new int[0], true)).getData();
        String activityId = json.getJSONArray("network_activities").getJSONObject(0).getJSONArray("ids").getString(0);
        DeleteActivityRequest request = new DeleteActivityRequest(activityId, true);
        DeleteActivityResponse response = this.client.execute(request);
        ActivityTest.assertNotNull((Object)((Object)response));
        ActivityTest.assertTrue((boolean)((Boolean)response.getData()));
    }

    public void testShareLinkAndDelete() throws OXException, IOException, JSONException {
        ShareLinkRequest request = new ShareLinkRequest("http://www.google.de", true);
        ShareLinkResponse response = this.client.execute(request);
        ActivityTest.assertNull((String)("Got an exception: " + (Object)((Object)response.getException())), (Object)((Object)response.getException()));
        ActivityTest.assertNotNull((Object)response.getData());
        ActivityTest.assertTrue((boolean)((Boolean)response.getData()));
    }

    public void testShareActivityAndDelete() throws OXException, IOException, JSONException {
        String activityId;
        ShareActivityRequest request;
        List<String> activities = this.getActivitiesIdContainingPermission("SHARE");
        AbstractAJAXResponse response = null;
        Iterator<String> i$ = activities.iterator();
        while (i$.hasNext() && (response = this.client.execute(request = new ShareActivityRequest(activityId = i$.next(), "My shared activity", false))).hasError()) {
            OXException exc = response.getException();
            if ("XING".equals(exc.getPrefix()) && 2 == exc.getCode()) continue;
            ActivityTest.fail((String)exc.getMessage());
        }
        ActivityTest.assertNotNull(response);
        ActivityTest.assertNull((String)("Got an exception: " + (Object)((Object)response.getException())), (Object)((Object)response.getException()));
        ActivityTest.assertNotNull((Object)response.getData());
        ActivityTest.assertTrue((boolean)((Boolean)response.getData()));
    }

    public void testCommentCRUD() throws OXException, IOException, JSONException {
        String activityId = this.getActivityIdContainingPermission("COMMENT");
        CommentActivityRequest createRequest = new CommentActivityRequest(activityId, UUID.randomUUID().toString(), true);
        CommentActivityResponse createResponse = this.client.execute(createRequest);
        ActivityTest.assertNotNull((Object)((Object)createResponse));
        JSONObject json = (JSONObject)this.client.execute(new UserFeedRequest("dimitribronkowitsch@googlemail.com", -1L, -1L, new int[0], true)).getData();
        GetCommentsRequest getRequest = new GetCommentsRequest(activityId, -1, -1, new int[0], true);
        GetCommentsResponse getResponse = this.client.execute(getRequest);
        ActivityTest.assertNotNull((Object)((Object)getResponse));
        int commentAmount = json.getJSONArray("network_activities").getJSONObject(0).getJSONObject("comments").getInt("amount");
        if (commentAmount > 0) {
            String commentId = json.getJSONArray("network_activities").getJSONObject(0).getJSONObject("comments").getJSONArray("latest_comments").getJSONObject(0).getString("id");
            DeleteCommentRequest deleteRequest = new DeleteCommentRequest(activityId, commentId, false);
            DeleteCommentResponse deleteResponse = this.client.execute(deleteRequest);
            ActivityTest.assertNotNull((Object)((Object)deleteResponse));
        }
    }

    private String getActivityIdContainingPermission(String permission) throws OXException, IOException, JSONException {
        JSONObject json = (JSONObject)this.client.execute(new UserFeedRequest("dimitribronkowitsch@googlemail.com", -1L, -1L, new int[0], true)).getData();
        JSONArray networkActivities = json.getJSONArray("network_activities");
        ActivityTest.assertNotNull((Object)networkActivities);
        String activityId = "-1";
        boolean found = false;
        for (int i = 0; i < networkActivities.length(); ++i) {
            JSONObject activity = (JSONObject)networkActivities.get(i);
            ActivityTest.assertTrue((String)"Attribute \"ids\" not found", (boolean)activity.hasAndNotNull("ids"));
            ActivityTest.assertTrue((String)"Attribute \"possible_actions\" not found", (boolean)activity.hasAndNotNull("possible_actions"));
            JSONArray possibleActionsJSON = activity.getJSONArray("possible_actions");
            for (int j = 0; j < possibleActionsJSON.length(); ++j) {
                String possibleActionObj = (String)possibleActionsJSON.get(j);
                if (!possibleActionObj.equals(permission)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            activityId = activity.getJSONArray("ids").getString(0);
            break;
        }
        ActivityTest.assertTrue((String)("An activity with permission " + permission + " could not being found "), (boolean)found);
        return activityId;
    }

    private List<String> getActivitiesIdContainingPermission(String permission) throws OXException, IOException, JSONException {
        JSONObject json = (JSONObject)this.client.execute(new UserFeedRequest("dimitribronkowitsch@googlemail.com", -1L, -1L, new int[0], true)).getData();
        JSONArray networkActivities = json.getJSONArray("network_activities");
        ActivityTest.assertNotNull((Object)networkActivities);
        ArrayList<String> activitiesIds = new ArrayList<String>();
        for (int i = 0; i < networkActivities.length(); ++i) {
            JSONObject activity = (JSONObject)networkActivities.get(i);
            ActivityTest.assertTrue((String)"Attribute \"ids\" not found", (boolean)activity.hasAndNotNull("ids"));
            ActivityTest.assertTrue((String)"Attribute \"possible_actions\" not found", (boolean)activity.hasAndNotNull("possible_actions"));
            JSONArray possibleActionsJSON = activity.getJSONArray("possible_actions");
            for (int j = 0; j < possibleActionsJSON.length(); ++j) {
                String possibleActionObj = (String)possibleActionsJSON.get(j);
                if (!possibleActionObj.equals(permission)) continue;
                activitiesIds.add(activity.getJSONArray("ids").getString(0));
            }
        }
        ActivityTest.assertTrue((String)("An activity with permission " + permission + " could not being found "), (activitiesIds.size() > 0 ? 1 : 0) != 0);
        return activitiesIds;
    }
}

