/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.TimeZone;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.json.JSONException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class Bug27840Test
extends AbstractTaskTest {
    private AJAXClient client;
    private Task task;
    private TimeZone tz;

    public Bug27840Test(String name) {
        super(name);
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.tz = this.getTimeZone();
        this.task = Create.createWithDefaults(this.getPrivateFolder(), "Task to test for bug 27840");
        this.task.setTargetCosts(new BigDecimal("9999999999.99"));
        this.task.setActualCosts(new BigDecimal("-9999999999.99"));
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.task));
        super.tearDown();
    }

    @Test
    public void testForBug() throws OXException, IOException, JSONException {
        this.client.execute(new InsertRequest(this.task, this.tz)).fillTask(this.task);
        GetResponse response = this.client.execute(new GetRequest(this.task));
        Task test = response.getTask(this.tz);
        Assert.assertThat((String)"Actual costs not equal", (Object)test.getActualCosts(), (Matcher)CoreMatchers.equalTo((Object)this.task.getActualCosts()));
        Assert.assertThat((String)"Target costs not equal", (Object)test.getTargetCosts(), (Matcher)CoreMatchers.equalTo((Object)this.task.getTargetCosts()));
        this.task = test;
    }
}

