/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.subscribe.test;

import com.openexchange.ajax.subscribe.actions.DeleteSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.DeleteSubscriptionResponse;
import com.openexchange.ajax.subscribe.actions.GetSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.GetSubscriptionResponse;
import com.openexchange.ajax.subscribe.actions.NewSubscriptionRequest;
import com.openexchange.ajax.subscribe.actions.NewSubscriptionResponse;
import com.openexchange.ajax.subscribe.test.AbstractSubscriptionTest;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Autoboxing;
import com.openexchange.subscribe.Subscription;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class DeleteSubscriptionTest
extends AbstractSubscriptionTest {
    public DeleteSubscriptionTest(String name) {
        super(name);
    }

    public void testDeleteOMXFSubscriptionShouldAlwaysWork() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = this.getFolderManager().generatePublicFolder("subscriptionTest", 3, this.getClient().getValues().getPrivateContactFolder(), this.getClient().getValues().getUserId());
        this.getFolderManager().insertFolderOnServer(folder);
        DynamicFormDescription form = this.generateFormDescription();
        Subscription expected = this.generateOXMFSubscription(form);
        expected.setFolderId(String.valueOf(folder.getObjectID()));
        NewSubscriptionRequest newReq = new NewSubscriptionRequest(expected, form);
        NewSubscriptionResponse newResp = this.getClient().execute(newReq);
        DeleteSubscriptionTest.assertFalse((String)"Should succeed creating the subscription", (boolean)newResp.hasError());
        expected.setId(newResp.getId());
        DeleteSubscriptionRequest delReq = new DeleteSubscriptionRequest(expected.getId());
        DeleteSubscriptionResponse delResp = this.getClient().execute(delReq);
        DeleteSubscriptionTest.assertFalse((String)"Should succeed deleting the subscription", (boolean)delResp.hasError());
        GetSubscriptionRequest getReq = new GetSubscriptionRequest(newResp.getId());
        GetSubscriptionResponse getResp = this.getClient().execute(getReq);
        DeleteSubscriptionTest.assertTrue((String)"Should fail trying to get subcription afte deletion", (boolean)getResp.hasError());
        DeleteSubscriptionTest.assertEquals((String)"Should return 1 in case of success", (Object)Autoboxing.I((int)1), (Object)delResp.getData());
    }
}

