/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.simple;

import com.openexchange.ajax.simple.GetWithBody;
import com.openexchange.ajax.simple.SimpleOXModule;
import com.openexchange.ajax.simple.SimpleResponse;
import com.openexchange.ajax.tools.JSONCoercion;
import com.openexchange.subscribe.helpers.TrustAllAdapter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.json.JSONException;
import org.json.JSONObject;

public class SimpleOXClient {
    private static final String BASE = "/ajax";
    private boolean debug = "true".equals(System.getProperty("ebug"));
    private final HttpClient client = new HttpClient();
    private String sessionID;

    public SimpleOXClient(String host, boolean secure) {
        if (secure) {
            Protocol https = new Protocol("https", (ProtocolSocketFactory)new TrustAllAdapter(), 443);
            this.client.getHostConfiguration().setHost(host, 443, https);
        } else {
            this.client.getHostConfiguration().setHost(host);
        }
    }

    public SimpleOXClient(String host) {
        this(host, false);
    }

    public String login(String login, String password) throws JSONException, IOException {
        JSONObject obj = this.raw("login", "login", "name", login, "password", password);
        if (obj.has("error")) {
            throw new RuntimeException("Unexpected Repsonse: " + obj.toString());
        }
        this.sessionID = obj.getString("session");
        return this.sessionID;
    }

    public boolean isLoggedIn() {
        return this.sessionID != null;
    }

    public SimpleOXModule getModule(String moduleName) {
        return new SimpleOXModule(this, moduleName);
    }

    public SimpleResponse call(String module, String action, Object ... parameters) throws JSONException, IOException {
        return new SimpleResponse(this.raw(module, action, parameters));
    }

    public JSONObject raw(String module, String action, Object ... parameters) throws JSONException, IOException {
        HttpMethod method = this.rawMethod(module, action, parameters);
        int statusCode = method.getStatusCode();
        if (statusCode != 200) {
            throw new IllegalStateException("Expected a return code of 200 but was " + statusCode);
        }
        String response = method.getResponseBodyAsString();
        if (this.debug) {
            System.out.println("Response: " + response);
        }
        return new JSONObject(response);
    }

    public HttpMethod rawMethod(String module, String action, Object ... parameters) throws JSONException, IOException {
        Object method;
        Map<String, Object> params = this.M(parameters);
        params.put("action", action);
        if (!params.containsKey("session") && this.isLoggedIn()) {
            params.put("session", this.sessionID);
        }
        String url = "/ajax/" + module;
        if (params.containsKey("body")) {
            String body = JSONCoercion.coerceToJSON((Object)params.remove("body")).toString();
            GetWithBody entityMethod = "getWithBody".equals(action) ? new GetWithBody(url) : new PutMethod(url);
            try {
                entityMethod.setRequestEntity((RequestEntity)new StringRequestEntity(body, "text/javascript", "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            method = entityMethod;
        } else {
            method = new GetMethod(url);
        }
        NameValuePair[] pairs = new NameValuePair[params.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            pairs[i++] = new NameValuePair(entry.getKey(), entry.getValue().toString());
        }
        method.setQueryString(pairs);
        this.client.executeMethod((HttpMethod)method);
        return method;
    }

    private Map<String, Object> M(Object ... parameters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < parameters.length; ++i) {
            map.put(parameters[i++].toString(), parameters[i]);
        }
        return map;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

