/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session.actions;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.session.actions.AbstractRequest;
import com.openexchange.ajax.session.actions.TokensParser;
import com.openexchange.ajax.session.actions.TokensResponse;

public final class TokensRequest
extends AbstractRequest<TokensResponse> {
    private String httpSessionId;
    private final boolean failOnError;

    public TokensRequest(String httpSessionId, String clientToken, String serverToken, String client, boolean failOnError) {
        super(new AJAXRequest.Parameter[]{new AJAXRequest.URLParameter("action", "tokens"), new AJAXRequest.FieldParameter("clientToken", clientToken), new AJAXRequest.FieldParameter("serverToken", serverToken), new AJAXRequest.FieldParameter("client", client)});
        this.httpSessionId = httpSessionId;
        this.failOnError = failOnError;
    }

    @Override
    public String getServletPath() {
        return super.getServletPath() + ";jsessionid=" + this.httpSessionId;
    }

    public TokensRequest(String httpSessionId, String clientToken, String serverToken, boolean failOnError) {
        this(httpSessionId, clientToken, serverToken, AJAXClient.class.getName(), failOnError);
    }

    public TokensRequest(String httpSessionId, String clientToken, String serverToken) {
        this(httpSessionId, clientToken, serverToken, true);
    }

    public TokensParser getParser() {
        return new TokensParser(this.failOnError);
    }
}

