/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.session.actions.FormLoginRequest;
import com.openexchange.ajax.session.actions.FormLoginResponse;
import com.openexchange.ajax.session.actions.StoreRequest;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.java.Strings;
import java.util.List;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;

public class Bug32695Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private String login;
    private String password;

    public Bug32695Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        AJAXConfig.init();
        this.login = AJAXConfig.getProperty(AJAXConfig.Property.LOGIN) + "@" + AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        this.password = AJAXConfig.getProperty(AJAXConfig.Property.PASSWORD);
        this.client = new AJAXClient(new AJAXSession(), true);
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.client && !Strings.isEmpty((String)this.client.getSession().getId())) {
            this.client.logout();
        }
        super.tearDown();
    }

    public void testAutoFormLogin() throws Exception {
        String firstSessionID = this.firstFormLogin(true);
        FormLoginRequest secondLoginRequest = new FormLoginRequest(this.login, this.password);
        secondLoginRequest.setCookiesNeeded(false);
        FormLoginResponse secondLoginResponse = this.client.execute(secondLoginRequest);
        String secondSessionID = secondLoginResponse.getSessionId();
        Bug32695Test.assertNotNull((String)"No session ID", (Object)secondSessionID);
        Bug32695Test.assertEquals((String)"Different session IDs", (String)firstSessionID, (String)secondSessionID);
    }

    public void testAutoFormLoginWithOtherUser() throws Exception {
        String firstSessionID = this.firstFormLogin(true);
        String secondLogin = AJAXConfig.getProperty(AJAXConfig.Property.SECONDUSER) + "@" + AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        String secondPassword = AJAXConfig.getProperty(AJAXConfig.Property.PASSWORD);
        FormLoginRequest secondLoginRequest = new FormLoginRequest(secondLogin, secondPassword);
        secondLoginRequest.setCookiesNeeded(false);
        FormLoginResponse secondLoginResponse = this.client.execute(secondLoginRequest);
        String secondSessionID = secondLoginResponse.getSessionId();
        Bug32695Test.assertFalse((String)"Same session ID", (boolean)firstSessionID.equals(secondSessionID));
        this.client.getSession().setId(secondSessionID);
    }

    public void testAutoFormLoginWithWrongCredentials() throws Exception {
        this.firstFormLogin(true);
        FormLoginRequest secondLoginRequest = new FormLoginRequest(this.login, "wrongpassword");
        secondLoginRequest.setCookiesNeeded(false);
        AssertionError expectedError = null;
        try {
            this.client.execute(secondLoginRequest);
        }
        catch (AssertionError e) {
            expectedError = e;
        }
        Bug32695Test.assertNotNull((String)"No errors performing second login with wrong password", (Object)expectedError);
    }

    public void testAutoFormLoginWithWrongSecretCookie() throws Exception {
        String firstSessionID = this.firstFormLogin(true);
        this.findCookie(LoginServlet.SECRET_PREFIX).setValue("wrongsecret");
        FormLoginRequest secondLoginRequest = new FormLoginRequest(this.login, this.password);
        secondLoginRequest.setCookiesNeeded(false);
        FormLoginResponse secondLoginResponse = this.client.execute(secondLoginRequest);
        String secondSessionID = secondLoginResponse.getSessionId();
        Bug32695Test.assertFalse((String)"Same session ID", (boolean)firstSessionID.equals(secondSessionID));
        this.client.getSession().setId(secondSessionID);
    }

    public void testAutoFormLoginWithWrongSessionCookie() throws Exception {
        String firstSessionID = this.firstFormLogin(true);
        this.findCookie(LoginServlet.SESSION_PREFIX).setValue("wrongsession");
        FormLoginRequest secondLoginRequest = new FormLoginRequest(this.login, this.password);
        secondLoginRequest.setCookiesNeeded(false);
        FormLoginResponse secondLoginResponse = this.client.execute(secondLoginRequest);
        String secondSessionID = secondLoginResponse.getSessionId();
        Bug32695Test.assertFalse((String)"Same session ID", (boolean)firstSessionID.equals(secondSessionID));
        this.client.getSession().setId(secondSessionID);
    }

    public void testAutoFormLoginWithoutStore() throws Exception {
        String firstSessionID = this.firstFormLogin(false);
        FormLoginRequest secondLoginRequest = new FormLoginRequest(this.login, this.password);
        secondLoginRequest.setCookiesNeeded(false);
        FormLoginResponse secondLoginResponse = this.client.execute(secondLoginRequest);
        String secondSessionID = secondLoginResponse.getSessionId();
        Bug32695Test.assertFalse((String)"Same session ID", (boolean)firstSessionID.equals(secondSessionID));
        this.client.getSession().setId(secondSessionID);
    }

    private String firstFormLogin(boolean store) throws Exception {
        FormLoginResponse loginResponse = this.client.execute(new FormLoginRequest(this.login, this.password));
        String sessionID = loginResponse.getSessionId();
        Bug32695Test.assertNotNull((String)"No session ID", (Object)sessionID);
        this.client.getSession().setId(sessionID);
        if (store) {
            this.client.execute(new StoreRequest(sessionID));
        }
        return sessionID;
    }

    private BasicClientCookie findCookie(String prefix) {
        List cookies = this.client.getSession().getHttpClient().getCookieStore().getCookies();
        for (int i = 0; i < cookies.size(); ++i) {
            if (!((Cookie)cookies.get(i)).getName().startsWith(prefix)) continue;
            return (BasicClientCookie)cookies.get(i);
        }
        Bug32695Test.fail((String)("No cookie with prefix \"" + prefix + "\" found"));
        return null;
    }
}

