/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.FolderTools;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.reminder.ReminderTools;
import com.openexchange.ajax.reminder.actions.RangeRequest;
import com.openexchange.ajax.reminder.actions.RangeResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class SharedFolderTest
extends AbstractAJAXSession {
    AJAXClient client;
    AJAXClient client2;
    FolderObject sharedFolder;
    Appointment firstAppointment;
    Appointment secondAppointment;
    TimeZone tz;

    public SharedFolderTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.tz = this.client.getValues().getTimeZone();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.sharedFolder = Create.createPrivateFolder("Bug 17327 shared folder", 2, this.client.getValues().getUserId(), new OCLPermission[0]);
        this.sharedFolder.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        InsertResponse folderInsertResponse = this.client.execute(new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OUTLOOK, this.sharedFolder, true));
        folderInsertResponse.fillObject((DataObject)this.sharedFolder);
        FolderTools.shareFolder(this.client, EnumAPI.OUTLOOK, this.sharedFolder.getObjectID(), this.client2.getValues().getUserId(), 4, 4, 4, 4);
    }

    public void testAppointmentCreatorCanChangeReminder() throws Exception {
        this.firstAppointment = this.createAppointment();
        this.firstAppointment.setAlarm(15);
        AppointmentInsertResponse appointmentInsertResponse = this.client.execute(new InsertRequest(this.firstAppointment, this.tz, true));
        appointmentInsertResponse.fillAppointment(this.firstAppointment);
        GetResponse getResponse = this.client.execute(new GetRequest(this.firstAppointment));
        Appointment toCompare = getResponse.getAppointment(this.tz);
        SharedFolderTest.assertEquals((String)"Appointment did not contain correct alarm time.", (int)this.firstAppointment.getAlarm(), (int)toCompare.getAlarm());
        RangeRequest rangeReq = new RangeRequest(this.firstAppointment.getEndDate());
        RangeResponse rangeResp = this.client.execute(rangeReq);
        ReminderObject reminder = ReminderTools.searchByTarget(rangeResp.getReminder(this.tz), this.firstAppointment.getObjectID());
        SharedFolderTest.assertNotNull((String)"No reminder was found.", (Object)reminder);
        GregorianCalendar remCal = new GregorianCalendar();
        remCal.setTime(this.firstAppointment.getStartDate());
        ((Calendar)remCal).add(12, -15);
        SharedFolderTest.assertEquals((String)"Reminder date was not set correctly.", (Object)remCal.getTime(), (Object)reminder.getDate());
        this.firstAppointment.setAlarm(30);
        UpdateResponse updateResponse = this.client.execute(new UpdateRequest(this.firstAppointment, this.tz));
        this.firstAppointment.setLastModified(updateResponse.getTimestamp());
        GetResponse getResponse2 = this.client.execute(new GetRequest(this.firstAppointment));
        Appointment toCompare2 = getResponse2.getAppointment(this.tz);
        SharedFolderTest.assertEquals((String)"Appointment did not contain correct alarm time.", (int)this.firstAppointment.getAlarm(), (int)toCompare2.getAlarm());
        RangeRequest rangeReq2 = new RangeRequest(this.firstAppointment.getEndDate());
        RangeResponse rangeResp2 = this.client.execute(rangeReq2);
        ReminderObject reminder2 = ReminderTools.searchByTarget(rangeResp2.getReminder(this.tz), this.firstAppointment.getObjectID());
        SharedFolderTest.assertNotNull((String)"No reminder was found.", (Object)reminder2);
        GregorianCalendar remCal2 = new GregorianCalendar();
        remCal2.setTime(this.firstAppointment.getStartDate());
        ((Calendar)remCal2).add(12, -30);
        SharedFolderTest.assertEquals((String)"Reminder date was not set correctly.", (Object)remCal2.getTime(), (Object)reminder2.getDate());
        this.client.execute(new com.openexchange.ajax.appointment.action.DeleteRequest(this.firstAppointment));
    }

    public void testSecretaryCanChangeReminder() throws Exception {
        this.secondAppointment = this.createAppointment();
        this.secondAppointment.setAlarm(15);
        AppointmentInsertResponse appointmentInsertResponse = this.client2.execute(new InsertRequest(this.secondAppointment, this.tz, true));
        appointmentInsertResponse.fillAppointment(this.secondAppointment);
        GetResponse getResponse = this.client.execute(new GetRequest(this.secondAppointment));
        Appointment toCompare = getResponse.getAppointment(this.tz);
        SharedFolderTest.assertEquals((String)"Appointment did not contain correct alarm time.", (int)this.secondAppointment.getAlarm(), (int)toCompare.getAlarm());
        RangeRequest rangeReq = new RangeRequest(this.secondAppointment.getEndDate());
        RangeResponse rangeResp = this.client.execute(rangeReq);
        ReminderObject reminder = ReminderTools.searchByTarget(rangeResp.getReminder(this.tz), this.secondAppointment.getObjectID());
        SharedFolderTest.assertNotNull((String)"No reminder was found.", (Object)reminder);
        GregorianCalendar remCal = new GregorianCalendar();
        remCal.setTime(this.secondAppointment.getStartDate());
        ((Calendar)remCal).add(12, -15);
        SharedFolderTest.assertEquals((String)"Reminder date was not set correctly.", (Object)remCal.getTime(), (Object)reminder.getDate());
        this.secondAppointment.setAlarm(30);
        UpdateResponse updateResponse = this.client2.execute(new UpdateRequest(this.secondAppointment, this.tz));
        this.secondAppointment.setLastModified(updateResponse.getTimestamp());
        GetResponse getResponse2 = this.client.execute(new GetRequest(this.secondAppointment));
        Appointment toCompare2 = getResponse2.getAppointment(this.tz);
        SharedFolderTest.assertEquals((String)"Appointment did not contain correct alarm time.", (int)this.secondAppointment.getAlarm(), (int)toCompare2.getAlarm());
        RangeRequest rangeReq2 = new RangeRequest(this.secondAppointment.getEndDate());
        RangeResponse rangeResp2 = this.client.execute(rangeReq2);
        ReminderObject reminder2 = ReminderTools.searchByTarget(rangeResp2.getReminder(this.tz), this.secondAppointment.getObjectID());
        SharedFolderTest.assertNotNull((String)"No reminder was found.", (Object)reminder2);
        GregorianCalendar remCal2 = new GregorianCalendar();
        remCal2.setTime(this.secondAppointment.getStartDate());
        ((Calendar)remCal2).add(12, -30);
        SharedFolderTest.assertEquals((String)"Reminder date was not set correctly.", (Object)remCal2.getTime(), (Object)reminder2.getDate());
        this.client2.execute(new com.openexchange.ajax.appointment.action.DeleteRequest(this.secondAppointment));
    }

    @Override
    public void tearDown() throws Exception {
        this.client.execute(new DeleteRequest((API)EnumAPI.OUTLOOK, this.sharedFolder));
        this.client2.logout();
        super.tearDown();
    }

    public Appointment createAppointment() throws Exception {
        Appointment appointment = new Appointment();
        appointment.setTitle("SharedFolder Testappointment");
        appointment.setParentFolderID(this.sharedFolder.getObjectID());
        appointment.setIgnoreConflicts(true);
        Calendar cal = TimeTools.createCalendar(this.tz);
        appointment.setStartDate(cal.getTime());
        cal.add(10, 2);
        appointment.setEndDate(cal.getTime());
        return appointment;
    }
}

