/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mailaccount;

import com.openexchange.ajax.mailaccount.AbstractMailAccountTest;
import com.openexchange.ajax.mailaccount.actions.MailAccountAllRequest;
import com.openexchange.ajax.mailaccount.actions.MailAccountAllResponse;
import com.openexchange.ajax.mailaccount.actions.MailAccountGetRequest;
import com.openexchange.ajax.mailaccount.actions.MailAccountGetResponse;
import com.openexchange.ajax.mailaccount.actions.MailAccountListRequest;
import com.openexchange.ajax.mailaccount.actions.MailAccountListResponse;
import com.openexchange.ajax.mailaccount.actions.MailAccountUpdateRequest;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.AttributeSwitch;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.json.fields.GetSwitch;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class MailAccountLifecycleTest
extends AbstractMailAccountTest {
    public MailAccountLifecycleTest(String name) {
        super(name);
    }

    @Override
    public void tearDown() throws Exception {
        if (null != this.mailAccountDescription && 0 != this.mailAccountDescription.getId()) {
            this.deleteMailAccount();
        }
        super.tearDown();
    }

    public void testLifeCycle() throws OXException, IOException, SAXException, JSONException, OXException {
        this.createMailAccount();
        this.readByGet();
        this.readByAll();
        this.readByList();
        this.updateMailAccount();
        this.readByGet();
        this.readByAll();
        this.readByList();
    }

    private void updateMailAccount() throws OXException, IOException, JSONException {
        this.mailAccountDescription.setName("Other Name");
        this.mailAccountDescription.setLogin(MailConfig.getProperty(MailConfig.Property.LOGIN2));
        this.getClient().execute(new MailAccountUpdateRequest(this.mailAccountDescription, EnumSet.of(Attribute.NAME_LITERAL, Attribute.LOGIN_LITERAL)));
    }

    private void readByList() throws OXException, IOException, JSONException, OXException {
        MailAccountListResponse response = this.getClient().execute(new MailAccountListRequest(new int[]{this.mailAccountDescription.getId()}, this.allFields()));
        List<MailAccountDescription> descriptions = response.getDescriptions();
        MailAccountLifecycleTest.assertFalse((boolean)descriptions.isEmpty());
        MailAccountLifecycleTest.assertEquals((int)1, (int)descriptions.size());
        boolean found = false;
        for (MailAccountDescription description : descriptions) {
            if (description.getId() != this.mailAccountDescription.getId()) continue;
            this.compare(this.mailAccountDescription, description);
            found = true;
        }
        MailAccountLifecycleTest.assertTrue((String)"Did not find mail account in response", (boolean)found);
    }

    private void readByAll() throws OXException, IOException, JSONException, OXException {
        int[] fields = this.allFields();
        MailAccountAllResponse response = this.getClient().execute(new MailAccountAllRequest(fields));
        List<MailAccountDescription> descriptions = response.getDescriptions();
        MailAccountLifecycleTest.assertFalse((boolean)descriptions.isEmpty());
        boolean found = false;
        for (MailAccountDescription description : descriptions) {
            if (description.getId() != this.mailAccountDescription.getId()) continue;
            this.compare(this.mailAccountDescription, description);
            found = true;
        }
        MailAccountLifecycleTest.assertTrue((String)"Did not find mail account in response", (boolean)found);
    }

    private int[] allFields() {
        int[] fields = new int[Attribute.values().length];
        int index = 0;
        for (Attribute attr : Attribute.values()) {
            fields[index++] = attr.getId();
        }
        return fields;
    }

    private void readByGet() throws OXException, IOException, JSONException, OXException {
        MailAccountGetRequest request = new MailAccountGetRequest(this.mailAccountDescription.getId());
        MailAccountGetResponse response = this.getClient().execute(request);
        MailAccountDescription loaded = response.getAsDescription();
        this.compare(this.mailAccountDescription, loaded);
    }

    private void compare(MailAccountDescription expectedAcc, MailAccountDescription actualAcc) throws OXException {
        GetSwitch expectedSwitch = new GetSwitch(expectedAcc);
        GetSwitch actualSwitch = new GetSwitch(actualAcc);
        for (Attribute attribute : Attribute.values()) {
            if (attribute == Attribute.PASSWORD_LITERAL || attribute == Attribute.TRANSPORT_PASSWORD_LITERAL || attribute == Attribute.ARCHIVE_LITERAL || attribute == Attribute.TRANSPORT_LOGIN_LITERAL) continue;
            if (attribute == Attribute.CONFIRMED_HAM_FULLNAME_LITERAL) {
                this.compareByEnding(expectedSwitch, actualSwitch, attribute, Attribute.CONFIRMED_HAM_LITERAL);
                continue;
            }
            if (attribute == Attribute.CONFIRMED_SPAM_FULLNAME_LITERAL) {
                this.compareByEnding(expectedSwitch, actualSwitch, attribute, Attribute.CONFIRMED_SPAM_LITERAL);
                continue;
            }
            if (attribute == Attribute.TRASH_FULLNAME_LITERAL) {
                this.compareByEnding(expectedSwitch, actualSwitch, attribute, Attribute.TRASH_LITERAL);
                continue;
            }
            if (attribute == Attribute.SENT_FULLNAME_LITERAL) {
                this.compareByEnding(expectedSwitch, actualSwitch, attribute, Attribute.SENT_LITERAL);
                continue;
            }
            if (attribute == Attribute.DRAFTS_FULLNAME_LITERAL) {
                this.compareByEnding(expectedSwitch, actualSwitch, attribute, Attribute.DRAFTS_LITERAL);
                continue;
            }
            if (attribute == Attribute.SPAM_FULLNAME_LITERAL) {
                this.compareByEnding(expectedSwitch, actualSwitch, attribute, Attribute.SPAM_LITERAL);
                continue;
            }
            Object expected = attribute.doSwitch((AttributeSwitch)expectedSwitch);
            Object actual = attribute.doSwitch((AttributeSwitch)actualSwitch);
            MailAccountLifecycleTest.assertEquals((String)(attribute.getName() + " differs!"), (Object)expected, (Object)actual);
        }
    }

    private void compareByEnding(GetSwitch expectedSwitch, GetSwitch actualSwitch, Attribute attribute, Attribute compareAttribute) throws OXException {
        Object expected = attribute.doSwitch((AttributeSwitch)expectedSwitch);
        Object actual = attribute.doSwitch((AttributeSwitch)actualSwitch);
        if (actual != null && expected == null) {
            Object confHam = compareAttribute.doSwitch((AttributeSwitch)expectedSwitch);
            MailAccountLifecycleTest.assertNotNull((Object)confHam);
            String confHamString = (String)confHam;
            MailAccountLifecycleTest.assertTrue((boolean)((String)actual).endsWith(confHamString));
        } else {
            MailAccountLifecycleTest.assertEquals((String)(attribute.getName() + " differs!"), (Object)expected, (Object)actual);
        }
    }
}

