/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.filter;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.mail.filter.AbstractMailFilterTest;
import com.openexchange.ajax.mail.filter.Rule;
import com.openexchange.ajax.mail.filter.action.AbstractAction;
import com.openexchange.ajax.mail.filter.action.Vacation;
import com.openexchange.ajax.mail.filter.comparison.ContainsComparison;
import com.openexchange.ajax.mail.filter.test.HeaderTest;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;

public class Bug31253Test
extends AbstractMailFilterTest {
    private FolderObject folder;
    private AJAXClient client;

    public Bug31253Test(String name) {
        super(name);
    }

    @Override
    public void tearDown() throws Exception {
        if (this.folder != null) {
            this.client.execute(new DeleteRequest((API)EnumAPI.OX_NEW, this.folder));
        }
        super.tearDown();
    }

    public void testBug31253() throws Exception {
        AJAXSession ajaxSession = this.getSession();
        this.client = this.getClient();
        this.folder = Create.createPrivateFolder("Test for Bug31253", 7, this.client.getValues().getUserId(), new OCLPermission[0]);
        this.folder.setFullName(this.client.getValues().getInboxFolder() + "/Test for Bug31253");
        InsertResponse folderInsertResponse = this.client.execute(new InsertRequest(EnumAPI.OX_NEW, this.folder));
        folderInsertResponse.fillObject((DataObject)this.folder);
        Bug31253Test.deleteAllExistingRules(this.client.getValues().getDefaultAddress(), ajaxSession);
        Rule rule = new Rule();
        rule.setName("Test rule for Bug31253");
        rule.setActive(true);
        rule.setActioncmds(new AbstractAction[]{new Vacation(7, new String[]{this.client.getValues().getDefaultAddress()}, "Multiline subject with\nOK foobar for Bug 31253", "Multiline text with \nOK barfoo for Bug 31253")});
        ContainsComparison conComp = new ContainsComparison();
        rule.setTest(new HeaderTest(conComp, new String[]{"Subject"}, new String[]{"31253"}));
        String id = Bug31253Test.insertRule(rule, null, ajaxSession);
        String[] idArray = Bug31253Test.getIdArray(null, ajaxSession);
        Bug31253Test.assertEquals((String)"one rules expected", (int)1, (int)idArray.length);
        Rule loadRule = Bug31253Test.loadRules(this.client.getValues().getDefaultAddress(), id, ajaxSession);
        Bug31253Test.compareRule(rule, loadRule);
    }
}

