/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.addresscollector;

import com.openexchange.ajax.ContactTest;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.SendRequest;
import com.openexchange.ajax.mail.contenttypes.MailContentType;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Autoboxing;
import com.openexchange.mail.MailJSONField;
import com.openexchange.server.impl.OCLPermission;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class MailTest
extends AbstractMailTest {
    private AJAXClient client;

    public MailTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddressCollection() throws Throwable {
        FolderObject folder = null;
        try {
            folder = this.createContactFolder();
            this.clearFolder(this.getInboxFolder());
            this.clearFolder(this.getSentFolder());
            this.clearFolder(this.getTrashFolder());
            this.sendMail();
            this.checkContacts(folder.getObjectID());
            this.sendMail();
            this.checkContacts(folder.getObjectID());
        }
        finally {
            if (folder != null) {
                this.deleteContactFolder(folder);
            }
            this.clearFolder(this.getInboxFolder());
            this.clearFolder(this.getSentFolder());
            this.clearFolder(this.getTrashFolder());
        }
    }

    private void sendMail() throws OXException, JSONException, IOException, SAXException {
        JSONObject mail = new JSONObject();
        mail.put(MailJSONField.FROM.getKey(), (Object)this.getSendAddress());
        mail.put(MailJSONField.RECIPIENT_TO.getKey(), (Object)this.getSendAddress());
        mail.put(MailJSONField.RECIPIENT_CC.getKey(), (Object)"");
        mail.put(MailJSONField.RECIPIENT_BCC.getKey(), (Object)"");
        mail.put(MailJSONField.SUBJECT.getKey(), (Object)"Mail Test for Contact Collection.");
        mail.put(MailJSONField.PRIORITY.getKey(), (Object)"3");
        JSONObject bodyObject = new JSONObject();
        bodyObject.put(MailJSONField.CONTENT_TYPE.getKey(), (Object)MailContentType.ALTERNATIVE.toString());
        bodyObject.put(MailJSONField.CONTENT.getKey(), (Object)"Bodytext for Contact Collection Mail Test");
        JSONArray attachments = new JSONArray();
        attachments.put((Object)bodyObject);
        mail.put(MailJSONField.ATTACHMENTS.getKey(), (Object)attachments);
        Executor.execute(this.client, new SendRequest(mail.toString(), null));
    }

    private void checkContacts(int folderId) throws Exception {
        int[] cols = new int[]{1, 555};
        Contact[] contacts = ContactTest.listContact(this.client.getSession().getConversation(), folderId, cols, AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME), this.client.getSession().getId());
        MailTest.assertEquals((String)"Number of collected Contacts not correct.", (int)1, (int)contacts.length);
        MailTest.assertEquals((String)"Email does not match.", (String)this.getSendAddress(), (String)contacts[0].getEmail1());
    }

    private FolderObject createContactFolder() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = Create.createPrivateFolder("ContactCollectionFolder " + System.currentTimeMillis(), 3, this.client.getValues().getUserId(), new OCLPermission[0]);
        folder.setParentFolderID(this.client.getValues().getPrivateContactFolder());
        CommonInsertResponse response = Executor.execute(this.client, new InsertRequest(EnumAPI.OX_OLD, folder));
        folder.setObjectID(response.getId());
        folder.setLastModified(response.getTimestamp());
        this.client.execute(new SetRequest(Tree.ContactCollectEnabled, Autoboxing.B((boolean)true)));
        this.client.execute(new SetRequest(Tree.ContactCollectFolder, Autoboxing.I((int)folder.getObjectID())));
        return folder;
    }

    private void deleteContactFolder(FolderObject folder) throws OXException, IOException, SAXException, JSONException {
        Executor.execute(this.client, new SetRequest(Tree.ContactCollectEnabled, Autoboxing.B((boolean)false)));
        Executor.execute(this.client, new DeleteRequest((API)EnumAPI.OX_OLD, folder.getObjectID(), folder.getLastModified()));
    }
}

