/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.AllRequest;
import com.openexchange.ajax.mail.actions.AllResponse;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.groupware.search.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadSortTest
extends AbstractMailTest {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadSortTest.class);
    String mailObject_25kb;

    public ThreadSortTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        this.mailObject_25kb = this.createSelfAddressed25KBMailObject().toString();
    }

    @Override
    public void tearDown() throws Exception {
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        super.tearDown();
    }

    public void testAllThreadSort() throws Throwable {
        int numOfMails = 25;
        LOG.info("Sending 25 mails to fill emptied INBOX");
        String eml = "Message-Id: <4A002517.4650.0059.1@foobar.com>\nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Subject: Invitation for launch\n" + "Mime-Version: 1.0\n" + "Content-Type: text/plain; charset=\"UTF-8\"\n" + "Content-Transfer-Encoding: 8bit\n" + "\n" + "This is a MIME message. If you are reading this text, you may want to \n" + "consider changing to a mail reader or gateway that understands how to \n" + "properly handle MIME multipart messages.";
        for (int i = 0; i < 25; ++i) {
            this.getClient().execute(new NewMailRequest(this.client.getValues().getInboxFolder(), eml, -1, true));
            LOG.info("Appended " + (i + 1) + ". mail of " + 25);
        }
        AllResponse allR = Executor.execute(this.getSession(), new AllRequest(this.getInboxFolder(), COLUMNS_DEFAULT_LIST, 0, Order.DESCENDING, true).setThreadSort(true));
        if (allR.hasError()) {
            ThreadSortTest.fail((String)allR.getException().toString());
        }
        Object[][] array = allR.getArray();
        ThreadSortTest.assertNotNull((String)"Array of all request is null.", (Object)array);
        ThreadSortTest.assertEquals((String)"All request shows different number of mails.", (int)25, (int)array.length);
        ThreadSortTest.assertEquals((String)"Number of columns differs from request ones.", (int)COLUMNS_DEFAULT_LIST.length, (int)array[0].length);
        for (int i = 0; i < array.length; ++i) {
            Object[] inner = array[i];
            for (int j = 0; j < inner.length; ++j) {
                int threadLevel = Integer.parseInt(inner[2].toString());
                ThreadSortTest.assertTrue((String)("Illegal thread level value: " + threadLevel), (threadLevel >= 0 ? 1 : 0) != 0);
            }
        }
    }
}

