/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.ListRequest;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.mail.MailListField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ListTest
extends AbstractMailTest {
    private static final Logger LOG = LoggerFactory.getLogger(ListTest.class);

    public ListTest(String name) {
        super(name);
    }

    public void testList() throws Throwable {
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        String eml = "Message-Id: <4A002517.4650.0059.1@foobar.com>\nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: #ADDR#\nTo: #ADDR#\nSubject: Invitation for launch\nMime-Version: 1.0\nContent-Type: text/plain; charset=\"UTF-8\"\nContent-Transfer-Encoding: 8bit\n\nThis is a MIME message. If you are reading this text, you may want to \nconsider changing to a mail reader or gateway that understands how to \nproperly handle MIME multipart messages.".replaceAll("#ADDR#", this.getSendAddress());
        int numOfMails = 25;
        LOG.info("Sending 25 mails to fill emptied INBOX");
        for (int i = 0; i < 25; ++i) {
            this.getClient().execute(new NewMailRequest(this.client.getValues().getInboxFolder(), eml, -1, true));
            LOG.info("Appended " + (i + 1) + ". mail of " + 25);
        }
        String[][] folderAndIDs = this.getFolderAndIDs(this.getInboxFolder());
        int[] columns = new int[COLUMNS_DEFAULT_LIST.length + 1];
        System.arraycopy(COLUMNS_DEFAULT_LIST, 0, columns, 0, COLUMNS_DEFAULT_LIST.length);
        columns[columns.length - 1] = MailListField.ACCOUNT_NAME.getField();
        CommonListResponse response = Executor.execute(this.getSession(), new ListRequest(folderAndIDs, columns));
        if (response.hasError()) {
            ListTest.fail((String)response.getException().toString());
        }
        Object[][] array = response.getArray();
        ListTest.assertNotNull((String)"Array of list request is null.", (Object)array);
        ListTest.assertEquals((String)"List request shows different number of mails.", (int)25, (int)array.length);
        for (int i = 0; i < array.length; ++i) {
            Object[] fields = array[i];
            Object accountName = fields[fields.length - 1];
            ListTest.assertNotNull((String)"Account name is null.", (Object)accountName);
        }
        Executor.execute(this.getSession(), new DeleteRequest(folderAndIDs, true));
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
    }
}

