/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailTestManager;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.exception.OXException;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class CopyMailWithManagerTest
extends AbstractMailTest {
    private UserValues values;

    public CopyMailWithManagerTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
        this.clearFolder(this.values.getSentFolder());
        this.clearFolder(this.values.getInboxFolder());
        this.clearFolder(this.values.getDraftsFolder());
    }

    public void testShouldCopyFromSendToDrafts() throws OXException, JSONException, IOException, SAXException {
        MailTestManager manager = new MailTestManager(this.client, false);
        String destination = this.values.getDraftsFolder();
        TestMail myMail = new TestMail(this.values.getSendAddress(), this.values.getSendAddress(), "Testing copy with manager", "alternative", "Copying a mail we just sent and received vom the inbox to the draft folder");
        myMail = manager.send(myMail);
        TestMail movedMail = manager.copy(myMail, destination);
        CopyMailWithManagerTest.assertFalse((String)"Should get no errors when copying e-mail", (boolean)manager.getLastResponse().hasError());
        String newID = movedMail.getId();
        manager.get(destination, newID);
        CopyMailWithManagerTest.assertFalse((String)"Should get no errors when getting copied e-mail", (boolean)manager.getLastResponse().hasError());
        CopyMailWithManagerTest.assertFalse((String)"Should produce no conflicts when getting copied e-mail", (boolean)manager.getLastResponse().hasConflicts());
        manager.get(myMail.getFolderAndId());
        CopyMailWithManagerTest.assertFalse((String)"Should still find original e-mail", (boolean)manager.getLastResponse().hasError());
        manager.cleanUp();
        manager.get(destination, newID);
        CopyMailWithManagerTest.assertTrue((String)"Should not find copied e-mail after cleaning up", (boolean)manager.getLastResponse().hasError());
        manager.get(myMail.getFolderAndId());
        CopyMailWithManagerTest.assertTrue((String)"Should not find original e-mail after cleaning up", (boolean)manager.getLastResponse().hasError());
    }
}

