/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.mailaccount.actions.MailAccountDeleteRequest;
import com.openexchange.ajax.mailaccount.actions.MailAccountInsertRequest;
import com.openexchange.ajax.mailaccount.actions.MailAccountInsertResponse;
import com.openexchange.ajax.pop3.actions.StartPOP3ServerRequest;
import com.openexchange.ajax.pop3.actions.StartPOP3ServerResponse;
import com.openexchange.ajax.pop3.actions.StopPOP3ServerRequest;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mailaccount.MailAccountDescription;
import org.json.JSONException;
import org.json.JSONObject;

public class Bug30703Test
extends AbstractAJAXSession {
    private MailAccountDescription mailAccountDescription;

    public Bug30703Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            StopPOP3ServerRequest stopReq = new StopPOP3ServerRequest();
            this.client.execute(stopReq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.mailAccountDescription != null) {
                this.client.execute(new MailAccountDeleteRequest(this.mailAccountDescription.getId()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.tearDown();
    }

    public void testProtocolError() throws Exception {
        this.setupServerAndAccount(true, false);
        ListRequest listRequest = new ListRequest((API)EnumAPI.OX_NEW, "default" + this.mailAccountDescription.getId());
        ListResponse listResponse = this.client.execute(listRequest);
        this.assertException(ResponseWriter.getJSON((Response)listResponse.getResponse()), MimeMailExceptionCode.CONNECT_ERROR);
    }

    public void testWrongCredentials() throws Exception {
        this.setupServerAndAccount(false, true);
        ListRequest listRequest = new ListRequest((API)EnumAPI.OX_NEW, "default" + this.mailAccountDescription.getId());
        ListResponse listResponse = this.client.execute(listRequest);
        this.assertException(ResponseWriter.getJSON((Response)listResponse.getResponse()), MimeMailExceptionCode.INVALID_CREDENTIALS_EXT);
    }

    public void testServerOffline() throws Exception {
        this.setupAccount("localhost", 1234);
        ListRequest listRequest = new ListRequest((API)EnumAPI.OX_NEW, "default" + this.mailAccountDescription.getId());
        ListResponse listResponse = this.client.execute(listRequest);
        this.assertException(ResponseWriter.getJSON((Response)listResponse.getResponse()), MimeMailExceptionCode.CONNECT_ERROR);
    }

    private void assertException(JSONObject response, MimeMailExceptionCode exceptionCode) throws JSONException {
        String prefix = exceptionCode.getPrefix();
        int number = exceptionCode.getNumber();
        Bug30703Test.assertTrue((String)"No error in response object", (boolean)response.has("error"));
        String code = response.getString("code");
        String[] split = code.split("-");
        Bug30703Test.assertEquals((String)"Wrong prefix", (String)prefix, (String)split[0]);
        Bug30703Test.assertEquals((String)"Wrong number", (int)number, (int)Integer.parseInt(split[1]));
    }

    private void setupServerAndAccount(boolean failOnConnect, boolean failOnAuth) throws Exception {
        StartPOP3ServerRequest startReq = new StartPOP3ServerRequest(failOnConnect, failOnAuth);
        StartPOP3ServerResponse startResp = this.client.execute(startReq);
        String host = startResp.getHost();
        int port = startResp.getPort();
        this.setupAccount(host, port);
    }

    private void setupAccount(String host, int port) throws Exception {
        String user = "Bug30703_User" + Long.toString(System.currentTimeMillis());
        this.mailAccountDescription = new MailAccountDescription();
        this.mailAccountDescription.setName("Bug30703Test_Account");
        this.mailAccountDescription.setPrimaryAddress(user + "@test.invalid");
        this.mailAccountDescription.parseMailServerURL("pop3://" + host + ":" + port);
        this.mailAccountDescription.setLogin(user);
        this.mailAccountDescription.setPassword("secret");
        this.mailAccountDescription.parseTransportServerURL("smtp://" + host + ":" + port);
        this.mailAccountDescription.setTransportLogin(user);
        this.mailAccountDescription.setTransportPassword("secret");
        this.mailAccountDescription.setConfirmedSpam("confirmedSpam");
        this.mailAccountDescription.setConfirmedHam("confirmedHam");
        this.mailAccountDescription.setDrafts("Drafts");
        this.mailAccountDescription.setSent("Sent");
        this.mailAccountDescription.setTrash("Trash");
        this.mailAccountDescription.setSpam("Spam");
        this.mailAccountDescription.setSpamHandler("NoSpamHandler");
        MailAccountInsertResponse response = this.client.execute(new MailAccountInsertRequest(this.mailAccountDescription));
        response.fillObject(this.mailAccountDescription);
    }
}

