/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.kata;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.kata.Step;
import com.openexchange.exception.OXException;
import java.io.IOException;
import java.util.TimeZone;
import org.json.JSONException;
import org.junit.Assert;
import org.xml.sax.SAXException;

public abstract class AbstractStep
implements Step {
    protected String name;
    protected String expectedError;
    protected AJAXClient client;

    public AbstractStep(String name, String expectedError) {
        this.name = name;
        this.expectedError = expectedError;
    }

    protected void checkError(AbstractAJAXResponse response) {
        if (response.hasError()) {
            String message = response.getResponse().getErrorMessage();
            if (this.expectedError != null) {
                Assert.assertTrue((String)(this.name + " expected error: " + this.expectedError + " but got: " + message), (boolean)message.contains(this.expectedError));
            } else {
                Assert.fail((String)(this.name + " did not expect error, but failed with: " + message));
            }
        } else if (this.expectedError != null) {
            Assert.fail((String)(this.name + " expected error " + this.expectedError + " but didn't get any errors"));
        }
    }

    protected boolean expectsError() {
        return this.expectedError != null;
    }

    protected TimeZone getTimeZone() throws OXException, IOException, SAXException, JSONException {
        return this.client.getValues().getTimeZone();
    }

    protected <T extends AbstractAJAXResponse> T execute(AJAXRequest<T> request) {
        try {
            return this.client.execute(request);
        }
        catch (OXException e) {
            Assert.fail((String)("AjaxException during task creation: " + e.getLocalizedMessage()));
        }
        catch (IOException e) {
            Assert.fail((String)("IOException during task creation: " + e.getLocalizedMessage()));
        }
        catch (JSONException e) {
            Assert.fail((String)("JsonException during task creation: " + e.getLocalizedMessage()));
        }
        return null;
    }
}

