/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.jslob;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.jslob.AbstractJSlobTest;
import com.openexchange.ajax.jslob.actions.ListRequest;
import com.openexchange.ajax.jslob.actions.ListResponse;
import com.openexchange.jslob.JSlob;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public final class Bug28821Test
extends AbstractJSlobTest {
    private static final int NUM_THREADS = 4;

    public Bug28821Test(String name) {
        super(name);
    }

    @Override
    @BeforeClass
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @AfterClass
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testBug28821() {
        try {
            ListAction listAction;
            int length = 4;
            ListAction[] actions = new ListAction[4];
            CountDownLatch startLatch = new CountDownLatch(1);
            CountDownLatch finishedLatch = new CountDownLatch(4);
            actions[0] = listAction = new ListAction(startLatch, finishedLatch, this.client, "io.ox/portal", "io.ox/mail", "io.ox/contacts");
            Thread thread = new Thread(listAction);
            thread.start();
            actions[1] = listAction = new ListAction(startLatch, finishedLatch, this.client, "io.ox/settings/configjump", "io.ox/calendar");
            thread = new Thread(listAction);
            thread.start();
            actions[2] = listAction = new ListAction(startLatch, finishedLatch, this.client, "io.ox/files");
            thread = new Thread(listAction);
            thread.start();
            actions[3] = listAction = new ListAction(startLatch, finishedLatch, this.client, "io.ox/core", "io.ox/core/updates");
            thread = new Thread(listAction);
            thread.start();
            startLatch.countDown();
            finishedLatch.await();
            for (int i = 0; i < actions.length; ++i) {
                Throwable throwable = actions[i].getThrowable();
                Bug28821Test.assertNull((String)("An error occurred: " + throwable), (Object)throwable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug28821Test.fail((String)e.getMessage());
        }
    }

    private static final class ListAction
    implements Runnable {
        private final AJAXClient client;
        private final String[] identifiers;
        private final CountDownLatch startLatch;
        private final CountDownLatch finishedLatch;
        private Throwable throwable;

        ListAction(CountDownLatch startLatch, CountDownLatch finishedLatch, AJAXClient client, String ... identifiers) {
            this.startLatch = startLatch;
            this.finishedLatch = finishedLatch;
            this.client = client;
            this.identifiers = identifiers;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.startLatch.await();
                String[] identifiers = this.identifiers;
                ListRequest listRequest = new ListRequest(identifiers);
                ListResponse listResponse = this.client.execute(listRequest);
                List<JSlob> jSlobs = listResponse.getJSlobs();
                TestCase.assertEquals((String)"Number of JSlobs does not match.", (int)identifiers.length, (int)jSlobs.size());
                for (String id : identifiers) {
                    boolean found = false;
                    Iterator<JSlob> iterator = jSlobs.iterator();
                    while (!found && iterator.hasNext()) {
                        JSlob jSlob = iterator.next();
                        found = id.equals(jSlob.getId().getId());
                    }
                    TestCase.assertTrue((String)("JSlob not found: " + id), (boolean)found);
                }
            }
            catch (Exception e) {
                this.throwable = e;
            }
            catch (AssertionError e) {
                this.throwable = e;
            }
            finally {
                this.finishedLatch.countDown();
            }
        }
    }
}

