/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.test;

import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.infostore.actions.AllInfostoreRequest;
import com.openexchange.ajax.infostore.test.AbstractInfostoreTest;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.java.Streams;
import com.openexchange.java.util.UUIDs;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.junit.Test;

public final class Bug27722Test
extends AbstractInfostoreTest {
    private static final int TOTAL_ITEMS = 100;
    private static final int DELETED_ITEMS = 50;
    private FolderObject testFolder;
    private List<DocumentMetadata> items;

    public Bug27722Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.testFolder = this.fMgr.generatePrivateFolder(UUID.randomUUID().toString(), 8, this.client.getValues().getPrivateInfostoreFolder(), this.client.getValues().getUserId());
        this.testFolder = this.fMgr.insertFolderOnServer(this.testFolder);
        this.items = new ArrayList<DocumentMetadata>(100);
        for (int i = 0; i < 100; ++i) {
            File tempFile = null;
            try {
                FileOutputStream outputStream = null;
                try {
                    tempFile = File.createTempFile("file_" + i, ".tst");
                    tempFile.deleteOnExit();
                    outputStream = new FileOutputStream(tempFile);
                    outputStream.write(UUIDs.toByteArray((UUID)UUID.randomUUID()));
                    outputStream.flush();
                }
                catch (Throwable throwable) {
                    Streams.close(outputStream);
                    throw throwable;
                }
                Streams.close((Closeable)outputStream);
                DocumentMetadataImpl document = new DocumentMetadataImpl();
                document.setFolderId((long)this.testFolder.getObjectID());
                document.setTitle(tempFile.getName());
                document.setFileName(tempFile.getName());
                document.setVersion(1);
                document.setFileSize(tempFile.length());
                this.infoMgr.newAction((DocumentMetadata)document, tempFile);
                this.items.add((DocumentMetadata)document);
                continue;
            }
            finally {
                if (null != tempFile) {
                    tempFile.delete();
                }
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testDeleteManyFiles() throws Exception {
        ArrayList<Integer> objectIDs = new ArrayList<Integer>(50);
        ArrayList<Integer> folderIDs = new ArrayList<Integer>(50);
        Random random = new Random();
        while (objectIDs.size() < 50) {
            DocumentMetadata randomDocument = this.items.get(random.nextInt(100));
            Integer objectID = randomDocument.getId();
            if (objectIDs.contains(objectID)) continue;
            objectIDs.add(objectID);
            folderIDs.add((int)randomDocument.getFolderId());
        }
        this.infoMgr.deleteAction(objectIDs, folderIDs, this.infoMgr.getLastResponse().getTimestamp());
        long duration = this.infoMgr.getLastResponse().getRequestDuration();
        Bug27722Test.assertTrue((String)("deletion took " + duration + "ms, which is too long"), (500L > duration ? 1 : 0) != 0);
        int[] columns = new int[]{1};
        AllInfostoreRequest allRequest = new AllInfostoreRequest(this.testFolder.getObjectID(), columns, -1, null);
        AbstractColumnsResponse allResponse = this.getClient().execute(allRequest);
        Bug27722Test.assertEquals((String)"Unexpected object count", (int)50, (int)allResponse.getArray().length);
        for (Object[] object : allResponse) {
            Integer objectID = Integer.valueOf(object[0].toString());
            Bug27722Test.assertFalse((String)"Object not deleted", (boolean)objectIDs.contains(objectID));
        }
    }
}

