/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.infostore.actions.AbstractInfostoreRequest;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreParser;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreResponse;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.utils.Metadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONException;

public class UpdateInfostoreRequest
extends AbstractInfostoreRequest<UpdateInfostoreResponse> {
    private DocumentMetadata metadata;
    private File upload;
    private Metadata[] fields;
    private final int id;
    private final Date lastModified;

    public UpdateInfostoreRequest(int id, Date lastModified, File upload) {
        this.id = id;
        this.upload = upload;
        this.lastModified = lastModified;
    }

    public UpdateInfostoreRequest(DocumentMetadata data, Metadata[] fields, File upload, Date lastModified) {
        this.metadata = data;
        this.id = data.getId();
        this.lastModified = lastModified;
        this.upload = upload;
        this.fields = fields;
    }

    public UpdateInfostoreRequest(DocumentMetadata data, Metadata[] fields, Date lastModified) {
        this.metadata = data;
        this.id = data.getId();
        this.lastModified = lastModified;
        this.fields = fields;
    }

    public void setMetadata(DocumentMetadata metadata) {
        this.metadata = metadata;
    }

    public DocumentMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String getBody() throws JSONException {
        return this.writeJSON(this.getMetadata(), this.fields);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return null == this.upload ? AJAXRequest.Method.PUT : AJAXRequest.Method.UPLOAD;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        ArrayList<AJAXRequest.Parameter> tmp = new ArrayList<AJAXRequest.Parameter>(3);
        tmp.add(new AJAXRequest.Parameter("action", "update"));
        tmp.add(new AJAXRequest.Parameter("id", this.id));
        tmp.add(new AJAXRequest.Parameter("timestamp", this.lastModified));
        if (null != this.upload) {
            tmp.add(new AJAXRequest.FieldParameter("json", this.getBody()));
            tmp.add(new AJAXRequest.FileParameter("file", this.upload.getName(), new FileInputStream(this.upload), this.metadata.getFileMIMEType()));
        }
        return tmp.toArray(new AJAXRequest.Parameter[tmp.size()]);
    }

    public UpdateInfostoreParser getParser() {
        return new UpdateInfostoreParser(this.getFailOnError(), null != this.upload);
    }
}

