/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractListParser;
import com.openexchange.ajax.infostore.actions.AbstractInfostoreRequest;
import com.openexchange.ajax.infostore.actions.ListInfostoreResponse;
import com.openexchange.groupware.infostore.DocumentMetadata;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ListInfostoreRequest
extends AbstractInfostoreRequest<ListInfostoreResponse> {
    private final List<ListItem> items;
    private final int[] columns;

    public ListInfostoreRequest(int[] columns) {
        this(new LinkedList<ListItem>(), columns);
    }

    public ListInfostoreRequest(List<ListItem> items, int[] columns) {
        this.items = items;
        this.columns = columns;
    }

    public void addItem(ListItem item) {
        this.items.add(item);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        return new AJAXRequest.Parameter[]{new AJAXRequest.URLParameter("columns", this.columns), new AJAXRequest.Parameter("action", "list")};
    }

    public ListInfostoreParser getParser() {
        return new ListInfostoreParser(this.getFailOnError(), this.columns);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        JSONArray jItems = new JSONArray();
        for (ListItem item : this.items) {
            jItems.put((Object)item.toJSON());
        }
        return jItems;
    }

    public static final class ListItem {
        private final String folderId;
        private final String id;
        private final String version;

        public ListItem(DocumentMetadata metadata) {
            this(Long.toString(metadata.getFolderId()), Integer.toString(metadata.getId()), Integer.toString(metadata.getVersion()));
        }

        public ListItem(String folderId, String id) {
            this(folderId, id, null);
        }

        public ListItem(String folderId, String id, String version) {
            this.folderId = folderId;
            this.id = id;
            this.version = version;
        }

        public String getFolderId() {
            return this.folderId;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject jItem = new JSONObject();
            jItem.put("folder", (Object)this.folderId);
            jItem.put("id", (Object)this.id);
            jItem.put("version", (Object)this.version);
            return jItem;
        }
    }

    public static final class ListInfostoreParser
    extends AbstractListParser<ListInfostoreResponse> {
        public ListInfostoreParser(boolean failOnError, int[] columns) {
            super(failOnError, columns);
        }

        @Override
        protected ListInfostoreResponse instantiateResponse(Response response) {
            return new ListInfostoreResponse(response);
        }
    }
}

