/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.actions;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreRequest;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreResponse;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.GetInfostoreResponse;
import com.openexchange.ajax.infostore.actions.NewInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreResponse;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreRequest;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.utils.Metadata;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class InfostoreTestManager {
    private final Set<DocumentMetadata> createdEntities = new HashSet<DocumentMetadata>();
    private AJAXClient client;
    private boolean failOnError;
    private AbstractAJAXResponse lastResponse;

    public InfostoreTestManager() {
    }

    public InfostoreTestManager(AJAXClient client) {
        this();
        this.setClient(client);
    }

    public Set<DocumentMetadata> getCreatedEntities() {
        return this.createdEntities;
    }

    public void setClient(AJAXClient client) {
        this.client = client;
    }

    public AJAXClient getClient() {
        return this.client;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public AbstractAJAXResponse getLastResponse() {
        return this.lastResponse;
    }

    public void cleanUp() throws OXException, IOException, SAXException, JSONException {
        ArrayList<Integer> objectIDs = new ArrayList<Integer>(this.createdEntities.size());
        ArrayList<Integer> folderIDs = new ArrayList<Integer>(this.createdEntities.size());
        for (DocumentMetadata metadata : this.createdEntities) {
            objectIDs.add(metadata.getId());
            folderIDs.add((int)metadata.getFolderId());
        }
        this.deleteAction(objectIDs, folderIDs, new Date(Long.MAX_VALUE));
        this.createdEntities.clear();
    }

    private void removeFromCreatedEntities(Collection<Integer> ids) {
        for (int id : ids) {
            for (DocumentMetadata data : new HashSet<DocumentMetadata>(this.createdEntities)) {
                if (data.getId() != id) continue;
                this.createdEntities.remove(data);
            }
        }
    }

    public void newAction(DocumentMetadata data) throws OXException, IOException, SAXException, JSONException {
        NewInfostoreRequest newRequest = new NewInfostoreRequest(data);
        newRequest.setFailOnError(this.getFailOnError());
        NewInfostoreResponse newResponse = this.getClient().execute(newRequest);
        this.lastResponse = newResponse;
        data.setId(newResponse.getID());
        this.createdEntities.add(data);
    }

    public void newAction(DocumentMetadata data, File upload) throws OXException, IOException, SAXException, JSONException {
        NewInfostoreRequest newRequest = new NewInfostoreRequest(data, upload);
        newRequest.setFailOnError(this.getFailOnError());
        NewInfostoreResponse newResponse = this.getClient().execute(newRequest);
        this.lastResponse = newResponse;
        data.setId(newResponse.getID());
        this.createdEntities.add(data);
    }

    public void updateAction(DocumentMetadata data, Metadata[] fields, Date timestamp) throws OXException, IOException, JSONException {
        UpdateInfostoreRequest updateRequest = new UpdateInfostoreRequest(data, fields, timestamp);
        updateRequest.setFailOnError(this.getFailOnError());
        UpdateInfostoreResponse updateResponse = this.getClient().execute(updateRequest);
        this.lastResponse = updateResponse;
    }

    public void updateAction(DocumentMetadata data, File file, Metadata[] fields, Date timestamp) throws OXException, IOException, JSONException {
        UpdateInfostoreRequest updateRequest = new UpdateInfostoreRequest(data, fields, file, timestamp);
        updateRequest.setFailOnError(this.getFailOnError());
        UpdateInfostoreResponse updateResponse = this.getClient().execute(updateRequest);
        this.lastResponse = updateResponse;
    }

    public void deleteAction(List<Integer> ids, List<Integer> folders, Date timestamp) throws OXException, IOException, SAXException, JSONException {
        DeleteInfostoreRequest deleteRequest = new DeleteInfostoreRequest(ids, folders, timestamp);
        deleteRequest.setFailOnError(this.getFailOnError());
        DeleteInfostoreResponse deleteResponse = this.getClient().execute(deleteRequest);
        this.lastResponse = deleteResponse;
        this.removeFromCreatedEntities(ids);
    }

    public void deleteAction(int id, int folder, Date timestamp) throws OXException, IOException, SAXException, JSONException {
        this.deleteAction(Arrays.asList(id), Arrays.asList(folder), timestamp);
    }

    public void deleteAction(DocumentMetadata data) throws OXException, IOException, SAXException, JSONException {
        this.deleteAction(data.getId(), Long.valueOf(data.getFolderId()).intValue(), data.getLastModified());
    }

    public DocumentMetadata getAction(int id) throws OXException, JSONException, OXException, IOException, SAXException {
        GetInfostoreRequest getRequest = new GetInfostoreRequest(id);
        getRequest.setFailOnError(this.getFailOnError());
        GetInfostoreResponse getResponse = this.getClient().execute(getRequest);
        this.lastResponse = getResponse;
        return getResponse.getDocumentMetadata();
    }
}

