/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.test.TestInit;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class SearchTest
extends InfostoreAJAXTest {
    protected String[] all = null;
    private static final int[] COLS = new int[]{700, 706};

    public SearchTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        super.removeAll();
        this.removeDocumentsInFolder(this.folderId);
        this.all = new String[26];
        char[] alphabet = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        for (int i = 0; i < 26; ++i) {
            int id = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("title", "Test " + i, "description", "this is document " + alphabet[i], "folder_id", "" + this.folderId));
            this.all[i] = "Test " + i;
            this.clean.add(id);
        }
    }

    public void testBasic() throws Exception {
        Response res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "5", COLS, this.folderId, -1, null, -1, -1);
        SearchTest.assertNoError(res);
        SearchTest.assertTitles(res, "Test 5", "Test 15", "Test 25");
    }

    public void testPattern() throws Exception {
        Response res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "*", COLS, this.folderId);
        SearchTest.assertNoError(res);
        SearchTest.assertTitles(res, this.all);
        res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "Test ?5", COLS, this.folderId);
        SearchTest.assertNoError(res);
        SearchTest.assertTitles(res, "Test 15", "Test 25");
    }

    public void testAll() throws Exception {
        Response res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "", COLS, this.folderId);
        SearchTest.assertNoError(res);
        SearchTest.assertTitles(res, this.all);
    }

    public void testCaseInsensitive() throws Exception {
        Response res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "test", COLS, this.folderId);
        SearchTest.assertNoError(res);
        SearchTest.assertTitles(res, this.all);
    }

    public void testStartAndStop() throws Exception {
        Response res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "5", COLS, this.folderId, 706, "ASC", 0, 1);
        SearchTest.assertNoError(res);
        JSONArray arrayOfarrays = (JSONArray)res.getData();
        SearchTest.assertEquals((int)2, (int)arrayOfarrays.length());
        SearchTest.assertTitle(0, arrayOfarrays, "Test 5");
        SearchTest.assertTitle(1, arrayOfarrays, "Test 15");
        res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "5", COLS, this.folderId, 706, "DESC", 0, 1);
        SearchTest.assertNoError(res);
        arrayOfarrays = (JSONArray)res.getData();
        SearchTest.assertEquals((int)2, (int)arrayOfarrays.length());
        SearchTest.assertTitle(0, arrayOfarrays, "Test 25");
        SearchTest.assertTitle(1, arrayOfarrays, "Test 15");
        res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "5", COLS, this.folderId, 706, "DESC", 1, 2);
        SearchTest.assertNoError(res);
        arrayOfarrays = (JSONArray)res.getData();
        SearchTest.assertEquals((int)2, (int)arrayOfarrays.length());
        SearchTest.assertTitle(0, arrayOfarrays, "Test 15");
        SearchTest.assertTitle(1, arrayOfarrays, "Test 5");
        res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "5", COLS, this.folderId, 706, "DESC", 1, 5);
        SearchTest.assertNoError(res);
        arrayOfarrays = (JSONArray)res.getData();
        SearchTest.assertEquals((int)2, (int)arrayOfarrays.length());
        SearchTest.assertTitle(0, arrayOfarrays, "Test 15");
        SearchTest.assertTitle(1, arrayOfarrays, "Test 5");
    }

    public void testLimit() throws Exception {
        Response res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "5", COLS, this.folderId, 706, "ASC", 1);
        SearchTest.assertNoError(res);
        JSONArray arrayOfarrays = (JSONArray)res.getData();
        SearchTest.assertEquals((int)1, (int)arrayOfarrays.length());
        SearchTest.assertTitle(0, arrayOfarrays, "Test 5");
    }

    public void testSort() throws Exception {
        Response res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "5", COLS, this.folderId, 706, "ASC", -1, -1);
        SearchTest.assertNoError(res);
        JSONArray arrayOfarrays = (JSONArray)res.getData();
        SearchTest.assertTitle(0, arrayOfarrays, "Test 5");
        SearchTest.assertTitle(1, arrayOfarrays, "Test 15");
        SearchTest.assertTitle(2, arrayOfarrays, "Test 25");
        res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "5", COLS, this.folderId, 706, "DESC", -1, -1);
        SearchTest.assertNoError(res);
        arrayOfarrays = (JSONArray)res.getData();
        SearchTest.assertTitle(0, arrayOfarrays, "Test 25");
        SearchTest.assertTitle(1, arrayOfarrays, "Test 15");
        SearchTest.assertTitle(2, arrayOfarrays, "Test 5");
    }

    public void testVersions() throws Exception {
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        int id = (Integer)this.clean.get(0);
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m("title", "File"), upload, "text/plain");
        SearchTest.assertNoError(res);
        res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "File", COLS, this.folderId);
        SearchTest.assertNoError(res);
        SearchTest.assertTitles(res, "File");
        res = this.revert(this.getWebConversation(), this.getHostName(), this.sessionId, res.getTimestamp().getTime(), id);
        SearchTest.assertNoError(res);
        res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "1", COLS, this.folderId);
        SearchTest.assertNoError(res);
        SearchTest.assertTitles(res, "Test 1", "Test 10", "Test 11", "Test 12", "Test 13", "Test 14", "Test 15", "Test 16", "Test 17", "Test 18", "Test 19", "Test 21");
    }

    public void notestEscape() throws Exception {
        int id = (Integer)this.clean.get(0);
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m("title", "The mysterious ?"));
        SearchTest.assertNoError(res);
        res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "\\?", COLS, this.folderId);
        SearchTest.assertNoError(res);
        SearchTest.assertTitles(res, "The mysterious ?");
        res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m("title", "The * of all trades"));
        SearchTest.assertNoError(res);
        res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "\\*", COLS, this.folderId);
        SearchTest.assertNoError(res);
        SearchTest.assertTitles(res, "The * of all trades");
    }

    public void testPermissions() throws Exception {
        String sessionId2 = this.getSecondSessionId();
        Response res = this.search(this.getSecondWebConversation(), this.getHostName(), sessionId2, "*", COLS, this.folderId);
        SearchTest.assertTitles(res, new String[0]);
    }

    public void testCategories() throws Exception {
        int id = (Integer)this.clean.get(0);
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, id, Long.MAX_VALUE, this.m("categories", "[\"curiosity\", \"cat\", \"danger\"]"));
        SearchTest.assertNoError(res);
        res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "curiosity", COLS);
        SearchTest.assertNoError(res);
        SearchTest.assertTitles(res, "Test 0");
    }

    public void testLastModifiedUTC() throws JSONException, IOException, SAXException {
        Response res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "*", new int[]{6}, this.folderId);
        SearchTest.assertNoError(res);
        JSONArray results = (JSONArray)res.getData();
        int size = results.length();
        SearchTest.assertTrue((size > 0 ? 1 : 0) != 0);
        for (int i = 0; i < size; ++i) {
            JSONArray row = results.optJSONArray(i);
            SearchTest.assertNotNull((Object)row);
            SearchTest.assertTrue((row.length() > 0 ? 1 : 0) != 0);
            SearchTest.assertNotNull((Object)row.optLong(0));
        }
    }

    public void notestNumberOfVersions() throws JSONException, IOException, SAXException {
        Response res;
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        for (int i = 0; i < this.clean.size(); ++i) {
            res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (Integer)this.clean.get(0), Long.MAX_VALUE, this.m(new String[0]), upload, "text/plain");
            SearchTest.assertNoError(res);
        }
        res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, "*", new int[]{1, 711}, this.folderId);
        JSONArray rows = (JSONArray)res.getData();
        int size = rows.length();
        for (int i = 0; i < size; ++i) {
            JSONArray row = rows.getJSONArray(i);
            row.getInt(0);
            int numberOfVersions = row.getInt(1);
            SearchTest.assertEquals((int)1, (int)numberOfVersions);
        }
    }

    public void testBackslashFound() throws MalformedURLException, IOException, SAXException, JSONException {
        String title = "Test\\WithBackslash";
        int id = this.createNew(this.getWebConversation(), this.getHostName(), this.sessionId, this.m("title", title, "description", "this is document the backslasher", "folder_id", "" + this.folderId));
        this.clean.add(id);
        Response res = this.search(this.getWebConversation(), this.getHostName(), this.sessionId, title, new int[]{700, 1}, this.folderId);
        SearchTest.assertTitles(res, title);
    }

    public static void assertTitle(int index, JSONArray results, String title) throws JSONException {
        JSONArray entry = results.getJSONArray(index);
        SearchTest.assertEquals((String)title, (String)entry.getString(0));
    }

    public static void assertTitles(Response res, String ... titles) throws JSONException {
        JSONArray arrayOfarrays = (JSONArray)res.getData();
        HashSet<String> titlesSet = new HashSet<String>(Arrays.asList(titles));
        String error = "Expected: " + titlesSet + " but got " + arrayOfarrays;
        SearchTest.assertEquals((String)error, (int)titles.length, (int)arrayOfarrays.length());
        for (int i = 0; i < arrayOfarrays.length(); ++i) {
            JSONArray entry = arrayOfarrays.getJSONArray(i);
            SearchTest.assertTrue((String)error, (boolean)titlesSet.remove(entry.getString(0)));
        }
    }
}

