/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.container.Response;
import java.io.IOException;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class DeleteTest
extends InfostoreAJAXTest {
    public DeleteTest(String name) {
        super(name);
    }

    public void testBasic() throws Exception {
        super.removeAll();
        Response res = this.all(this.getWebConversation(), this.getHostName(), this.sessionId, this.folderId, new int[]{1});
        DeleteTest.assertNoError(res);
        JSONArray a = (JSONArray)res.getData();
        DeleteTest.assertEquals((int)0, (int)a.length());
        this.clean.clear();
    }

    public void testConflict() throws Exception {
        int[][] toDelete = new int[this.clean.size()][2];
        for (int i = 0; i < toDelete.length; ++i) {
            toDelete[i][0] = this.folderId;
            toDelete[i][1] = (Integer)this.clean.get(i);
        }
        int[] notDeleted = this.delete(this.getWebConversation(), this.getHostName(), this.sessionId, 0L, toDelete);
        DeleteTest.assertEquals((int)toDelete.length, (int)notDeleted.length);
        HashSet notDeletedExpect = new HashSet(this.clean);
        for (int i : notDeleted) {
            DeleteTest.assertTrue((boolean)notDeletedExpect.remove(i));
        }
        DeleteTest.assertTrue((boolean)notDeletedExpect.isEmpty());
        notDeletedExpect = new HashSet(this.clean);
        this.removeDocumentsAndFolders();
        this.clean.clear();
        notDeleted = this.delete(this.getWebConversation(), this.getHostName(), this.sessionId, 0L, toDelete);
        DeleteTest.assertEquals((int)toDelete.length, (int)notDeleted.length);
        for (int i : notDeleted) {
            DeleteTest.assertTrue((boolean)notDeletedExpect.remove(i));
        }
        DeleteTest.assertTrue((boolean)notDeletedExpect.isEmpty());
    }

    public void testDeleteSingle() throws JSONException, IOException, SAXException {
        int[] notDeleted = this.deleteSingle(this.getWebConversation(), this.getHostName(), this.sessionId, Long.MAX_VALUE, this.folderId, (Integer)this.clean.get(this.clean.size() - 1));
        DeleteTest.assertEquals((int)0, (int)notDeleted.length);
    }
}

