/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.ContactTest;
import com.openexchange.ajax.FolderTest;
import com.openexchange.ajax.config.ConfigTools;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.importexport.formats.Format;
import com.openexchange.tools.URLParameter;
import com.openexchange.tools.versit.Versit;
import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.VersitObject;
import com.openexchange.tools.versit.converter.OXContainerConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractVCardTest
extends AbstractAJAXTest {
    protected static final String IMPORT_URL = "/ajax/import";
    protected static final String EXPORT_URL = "/ajax/export";
    protected int contactFolderId = -1;
    protected int userId = -1;
    protected String emailaddress = null;
    protected TimeZone timeZone = null;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractVCardTest.class);

    public AbstractVCardTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        FolderObject contactFolderObject = FolderTest.getStandardContactFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
        this.contactFolderId = contactFolderObject.getObjectID();
        this.userId = contactFolderObject.getCreatedBy();
        this.timeZone = ConfigTools.getTimeZone(this.getWebConversation(), this.getHostName(), this.getSessionId());
        LOG.debug("use timezone: " + this.timeZone);
        Contact contactObj = ContactTest.loadUser(this.getWebConversation(), this.userId, 6, this.getHostName(), this.getSessionId());
        this.emailaddress = contactObj.getEmail1();
    }

    public static ImportResult[] importVCard(WebConversation webCon, Contact[] contactObj, int folderId, TimeZone timeZone, String emailaddress, String host, String session) throws Exception, OXException {
        host = AbstractVCardTest.appendPrefix(host);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        VersitDefinition contactDef = Versit.getDefinition((String)"text/vcard");
        VersitDefinition.Writer versitWriter = contactDef.getWriter((OutputStream)byteArrayOutputStream, "UTF-8");
        OXContainerConverter oxContainerConverter = new OXContainerConverter(timeZone, emailaddress);
        if (contactObj != null) {
            for (int a = 0; a < contactObj.length; ++a) {
                VersitObject versitObject = oxContainerConverter.convertContact(contactObj[a], "3.0");
                contactDef.write(versitWriter, versitObject);
            }
        }
        byteArrayOutputStream.flush();
        versitWriter.flush();
        oxContainerConverter.close();
        return AbstractVCardTest.importVCard(webCon, new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), folderId, timeZone, emailaddress, host, session);
    }

    public static ImportResult[] importVCard(WebConversation webCon, ByteArrayInputStream byteArrayInputStream, int folderId, TimeZone timeZone, String emailaddress, String host, String session) throws Exception, OXException {
        host = AbstractVCardTest.appendPrefix(host);
        URLParameter parameter = new URLParameter(true);
        parameter.setParameter("session", session);
        parameter.setParameter("action", Format.VCARD.getConstantName());
        parameter.setParameter("folder", folderId);
        PostMethodWebRequest req = new PostMethodWebRequest(host + IMPORT_URL + parameter.getURLParameters(), true);
        req.selectFile("file", "vcard-test.vcf", (InputStream)byteArrayInputStream, Format.VCARD.getMimeType());
        WebResponse resp = webCon.getResource((WebRequest)req);
        AbstractVCardTest.assertEquals((int)200, (int)resp.getResponseCode());
        JSONObject response = AbstractVCardTest.extractFromCallback(resp.getText());
        JSONArray jsonArray = response.getJSONArray("data");
        AbstractVCardTest.assertNotNull((String)"json array in response is null", (Object)jsonArray);
        ImportResult[] importResult = new ImportResult[jsonArray.length()];
        for (int a = 0; a < jsonArray.length(); ++a) {
            JSONObject jsonObj = jsonArray.getJSONObject(a);
            if (jsonObj.has("error")) {
                importResult[a] = new ImportResult();
                importResult[a].setException(new OXException(6666, jsonObj.getString("error"), new Object[0]));
                continue;
            }
            String objectId = jsonObj.getString("id");
            String folder = jsonObj.getString("folder_id");
            long timestamp = jsonObj.getLong("last_modified");
            importResult[a] = new ImportResult(objectId, folder, timestamp);
        }
        return importResult;
    }

    public Contact[] exportContact(WebConversation webCon, int inFolder, String mailaddress, TimeZone timeZone, String host, String session) throws Exception, OXException {
        host = AbstractVCardTest.appendPrefix(host);
        URLParameter parameter = new URLParameter(true);
        parameter.setParameter("session", session);
        parameter.setParameter("folder", inFolder);
        parameter.setParameter("action", Format.VCARD.getConstantName());
        GetMethodWebRequest req = new GetMethodWebRequest(host + EXPORT_URL + parameter.getURLParameters());
        WebResponse resp = webCon.getResponse((WebRequest)req);
        AbstractVCardTest.assertEquals((int)200, (int)resp.getResponseCode());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(resp.getText().getBytes());
        OXContainerConverter oxContainerConverter = new OXContainerConverter(timeZone, mailaddress);
        ArrayList<Contact> exportData = new ArrayList<Contact>();
        try {
            VersitDefinition def = Versit.getDefinition((String)"text/vcard");
            VersitDefinition.Reader versitReader = def.getReader((InputStream)byteArrayInputStream, "UTF-8");
            VersitObject versitObject = def.parse(versitReader);
            while (versitObject != null) {
                Contact contactObj = oxContainerConverter.convertContact(versitObject);
                contactObj.setParentFolderID(this.contactFolderId);
                exportData.add(contactObj);
                versitObject = def.parse(versitReader);
            }
        }
        catch (Exception exc) {
            throw new Exception(exc);
        }
        return exportData.toArray(new Contact[exportData.size()]);
    }
}

