/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;

public abstract class AbstractColumnsResponse
extends AbstractAJAXResponse
implements Iterable<Object[]> {
    private int[] columns;
    private Object[][] array;

    protected AbstractColumnsResponse(Response response) {
        super(response);
    }

    public Object[][] getArray() {
        return this.array;
    }

    void setArray(Object[][] array) {
        this.array = array;
    }

    @Override
    public Iterator<Object[]> iterator() {
        return Collections.unmodifiableList(Arrays.asList(this.array)).iterator();
    }

    public Object getValue(int row, int attributeId) {
        return this.array[row][this.getColumnPos(attributeId)];
    }

    public Iterator<Object> iterator(int attributeId) {
        final int columnPos = this.getColumnPos(attributeId);
        return new Iterator<Object>(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < AbstractColumnsResponse.this.getArray().length;
            }

            @Override
            public Object next() {
                return AbstractColumnsResponse.this.getArray()[this.pos++][columnPos];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getColumnPos(int attributeId) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] != attributeId) continue;
            return i;
        }
        return -1;
    }

    public int[] getColumns() {
        return this.columns;
    }

    public void setColumns(int[] columns) {
        this.columns = columns;
    }

    public int size() {
        return this.array.length;
    }
}

