/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.FolderUpdatesResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.folder.actions.UpdatesRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.AbstractUpdatesRequest;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;

public class AbstractFolderTest
extends AbstractAJAXSession {
    protected AJAXClient client;
    protected int userId;

    protected AbstractFolderTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.userId = this.client.getValues().getUserId();
    }

    protected List<FolderObject> createAndPersistSeveral(String title, int amount) throws Exception {
        List<FolderObject> severalFolders = this.createSeveral(title, amount);
        severalFolders = this.persistSeveral(severalFolders);
        return severalFolders;
    }

    private List<FolderObject> createSeveral(String name, int amount) {
        ArrayList<FolderObject> newFolders = new ArrayList<FolderObject>(amount);
        FolderType[] folderTypes = new FolderType[]{FolderType.CALENDAR, FolderType.CONTACT, FolderType.TASK};
        int numberOfTypes = folderTypes.length;
        for (int i = 0; i < amount; ++i) {
            int indexOfType = i % numberOfTypes;
            FolderType folderType = folderTypes[indexOfType];
            String serialName = name + "-" + folderType.getName() + "-" + i;
            FolderObject newFolder = this.createSingle(folderType.getId(), serialName);
            newFolders.add(newFolder);
        }
        return newFolders;
    }

    protected FolderObject createSingle(int folderModule, String folderName) {
        FolderObject newFolder = new FolderObject();
        newFolder.setParentFolderID(1);
        newFolder.setFolderName(folderName);
        newFolder.setModule(folderModule);
        OCLPermission permission = new OCLPermission();
        permission.setEntity(this.userId);
        permission.setGroupPermission(false);
        permission.setFolderAdmin(true);
        permission.setAllPermission(128, 128, 128, 128);
        newFolder.addPermission(permission);
        return newFolder;
    }

    public List<FolderObject> persistSeveral(List<FolderObject> newFolders) throws Exception {
        int numberOfFolders = newFolders.size();
        ArrayList<InsertRequest> insertFolderRequests = new ArrayList<InsertRequest>(numberOfFolders);
        for (FolderObject folder : newFolders) {
            insertFolderRequests.add(new InsertRequest(EnumAPI.OUTLOOK, folder));
        }
        MultipleRequest multipleRequest = MultipleRequest.create(insertFolderRequests.toArray(new InsertRequest[numberOfFolders]));
        MultipleResponse multipleResponse = (MultipleResponse)this.client.execute(multipleRequest);
        return this.updateFoldersWithTimeAndId(newFolders, multipleResponse);
    }

    private List<FolderObject> updateFoldersWithTimeAndId(List<FolderObject> folders, MultipleResponse<InsertResponse> insertResponses) throws Exception {
        for (int i = 0; i < folders.size(); ++i) {
            FolderObject currentFolder = folders.get(i);
            Response currentResponse = insertResponses.getResponse(i).getResponse();
            Date timestamp = currentResponse.getTimestamp();
            int objectID = Integer.parseInt((String)currentResponse.getData());
            currentFolder.setLastModified(timestamp);
            currentFolder.setObjectID(objectID);
        }
        return folders;
    }

    public void updateFolders(List<FolderObject> folders) {
        this.updateFolders(folders.toArray(new FolderObject[folders.size()]));
    }

    public void updateFolders(FolderObject ... folders) {
        int numAppointments = folders.length;
        UpdateRequest[] updateRequests = new UpdateRequest[numAppointments];
        for (int i = 0; i < numAppointments; ++i) {
            FolderObject folder = folders[i];
            folder.setFolderName(folder.getFolderName() + " was updated");
            updateRequests[i] = new UpdateRequest(EnumAPI.OUTLOOK, folder);
        }
        MultipleRequest multipleUpdate = MultipleRequest.create(updateRequests);
        MultipleResponse updateResponse = (MultipleResponse)this.client.executeSafe(multipleUpdate);
        for (int i = 0; i < numAppointments; ++i) {
            folders[i].setLastModified(((InsertResponse)((Object)updateResponse.getResponse(i))).getTimestamp());
        }
    }

    public void deleteFolders(List<FolderObject> folders) {
        this.deleteFolders(folders.toArray(new FolderObject[folders.size()]));
    }

    public void deleteFolders(FolderObject ... folders) {
        DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, folders);
        CommonDeleteResponse deleteResponse = this.client.executeSafe(deleteRequest);
        JSONArray failures = (JSONArray)deleteResponse.getData();
        AbstractFolderTest.assertTrue((boolean)failures.isEmpty());
    }

    public void deleteFolders(boolean hardDelete, FolderObject ... folders) {
        DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, folders);
        if (hardDelete) {
            deleteRequest.setHardDelete(hardDelete);
        }
        CommonDeleteResponse deleteResponse = this.client.executeSafe(deleteRequest);
        JSONArray failures = (JSONArray)deleteResponse.getData();
        AbstractFolderTest.assertTrue((boolean)failures.isEmpty());
    }

    public FolderUpdatesResponse listModifiedFolders(int inFolder, int[] cols, Date lastModified, AbstractUpdatesRequest.Ignore ignore) throws Exception {
        UpdatesRequest request = new UpdatesRequest(EnumAPI.OX_NEW, inFolder, cols, -1, null, lastModified, ignore);
        FolderUpdatesResponse response = this.client.execute(request);
        return response;
    }

    public static enum FolderType {
        TASK(1, "tasks"),
        CALENDAR(2, "calendar"),
        CONTACT(3, "contacts"),
        UNBOUND(4, "unbound"),
        SYSTEM_MODULE(5, "system"),
        MAIL(7, "mail"),
        INFOSTORE(8, "infostore"),
        MESSAGING(13, "messaging"),
        FILE(14, "infostore");

        private final int id;
        private final String name;

        private FolderType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

