/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.tasks;

import com.openexchange.ajax.attach.actions.AttachRequest;
import com.openexchange.ajax.folder.FolderTools;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.VisibleFoldersRequest;
import com.openexchange.ajax.folder.actions.VisibleFoldersResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import com.openexchange.find.basic.tasks.TaskType;
import com.openexchange.find.common.CommonFacetType;
import com.openexchange.find.common.FolderType;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.FacetType;
import com.openexchange.find.facet.Filter;
import com.openexchange.find.tasks.TasksFacetType;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.server.impl.OCLPermission;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONException;

public class FindTasksTestEnvironment {
    private static final FindTasksTestEnvironment INSTANCE = new FindTasksTestEnvironment();
    private FolderObject userAprivateTestFolder;
    private FolderObject userApublicTestFolder;
    private FolderObject userBsharedTestFolderRO;
    private FolderObject userBsharedTestFolderRW;
    private FolderObject userBprivateTestFolder;
    private FolderObject userBpublicTestFolder;
    private UserValues userA;
    private UserValues userB;
    private AJAXClient clientA;
    private AJAXClient clientB;
    private List<List<ActiveFacet>> facets = new ArrayList<List<ActiveFacet>>();
    private boolean cleanup = true;
    private Set<Integer> tasksToFind = new HashSet<Integer>();
    private static final UUID trackingID = UUID.randomUUID();
    private Map<String, List<Integer>> rootTasks = new HashMap<String, List<Integer>>();
    private Map<Integer, Task> tasks = new HashMap<Integer, Task>();

    public static FindTasksTestEnvironment getInstance() {
        return INSTANCE;
    }

    public void init() {
        try {
            this.initUsers();
            this.createFolderStructure();
            this.createAndInsertTasks();
            this.createFilters();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void initUsers() throws Exception {
        this.clientA = new AJAXClient(AJAXClient.User.User1);
        this.userA = this.clientA.getValues();
        this.clientB = new AJAXClient(AJAXClient.User.User2);
        this.userB = this.clientB.getValues();
    }

    private final void logout() throws Exception {
        if (this.clientA != null) {
            this.clientA.logout();
        }
        if (this.clientB != null) {
            this.clientB.logout();
        }
    }

    private final void createFolderStructure() throws OXException, IOException, Exception {
        InsertResponse insertResponseResp;
        com.openexchange.ajax.folder.actions.InsertRequest insertRequestReq;
        Map<String, FolderObject> foldersA = this.getFolderStructure(this.clientA, this.userA.getPrivateTaskFolder());
        Map<String, FolderObject> foldersB = this.getFolderStructure(this.clientB, this.userB.getPrivateTaskFolder());
        try {
            this.userAprivateTestFolder = com.openexchange.ajax.folder.Create.createPrivateFolder("UserA - findAPIPrivateTaskFolder", 1, this.userA.getUserId(), new OCLPermission[0]);
            this.userAprivateTestFolder.setParentFolderID(this.userA.getPrivateTaskFolder());
            insertRequestReq = new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_NEW, this.userAprivateTestFolder, false);
            insertResponseResp = this.clientA.execute(insertRequestReq);
            insertResponseResp.fillObject((DataObject)this.userAprivateTestFolder);
        }
        catch (OXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.userAprivateTestFolder.getObjectID() == 0) {
            this.userAprivateTestFolder.setObjectID(foldersA.get("UserA - findAPIPrivateTaskFolder").getObjectID());
        }
        try {
            this.userApublicTestFolder = com.openexchange.ajax.folder.Create.createPublicFolder(this.clientA, "UserA - findAPIPublicTaskFolder", 1, false);
        }
        catch (OXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.userApublicTestFolder.getObjectID() == 0) {
            this.userApublicTestFolder.setObjectID(foldersA.get("UserA - findAPIPublicTaskFolder").getObjectID());
        }
        try {
            this.userBsharedTestFolderRO = com.openexchange.ajax.folder.Create.createPrivateFolder("UserB - findAPIPrivateSharedTaskFolder - RO", 1, this.userB.getUserId(), new OCLPermission[0]);
            this.userBsharedTestFolderRO.setParentFolderID(this.userB.getPrivateTaskFolder());
            insertRequestReq = new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_NEW, this.userBsharedTestFolderRO, false);
            insertResponseResp = this.clientB.execute(insertRequestReq);
            insertResponseResp.fillObject((DataObject)this.userBsharedTestFolderRO);
        }
        catch (OXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.userBsharedTestFolderRO.getObjectID() == 0) {
            this.userBsharedTestFolderRO.setObjectID(foldersB.get("UserB - findAPIPrivateSharedTaskFolder - RO").getObjectID());
        }
        try {
            FolderTools.shareFolder(this.clientB, EnumAPI.OX_NEW, this.userBsharedTestFolderRO.getObjectID(), this.userA.getUserId(), 2, 4, 0, 0);
        }
        catch (OXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.userBsharedTestFolderRW = com.openexchange.ajax.folder.Create.createPrivateFolder("UserB - findAPIPrivateSharedTaskFolder - RW", 1, this.userB.getUserId(), new OCLPermission[0]);
            this.userBsharedTestFolderRW.setParentFolderID(this.userB.getPrivateTaskFolder());
            insertRequestReq = new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_NEW, this.userBsharedTestFolderRW, false);
            insertResponseResp = this.clientB.execute(insertRequestReq);
            insertResponseResp.fillObject((DataObject)this.userBsharedTestFolderRW);
        }
        catch (OXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.userBsharedTestFolderRW.getObjectID() == 0) {
            this.userBsharedTestFolderRW.setObjectID(foldersB.get("UserB - findAPIPrivateSharedTaskFolder - RW").getObjectID());
        }
        try {
            FolderTools.shareFolder(this.clientB, EnumAPI.OX_NEW, this.userBsharedTestFolderRW.getObjectID(), this.userA.getUserId(), 2, 4, 4, 4);
        }
        catch (OXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.userBprivateTestFolder = com.openexchange.ajax.folder.Create.createPrivateFolder("UserB - findAPIPrivateTaskFolder - NA", 1, this.userB.getUserId(), new OCLPermission[0]);
            this.userBprivateTestFolder.setParentFolderID(this.userB.getPrivateTaskFolder());
            insertRequestReq = new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_NEW, this.userBprivateTestFolder, false);
            insertResponseResp = this.clientB.execute(insertRequestReq);
            insertResponseResp.fillObject((DataObject)this.userBprivateTestFolder);
        }
        catch (OXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.userBprivateTestFolder.getObjectID() == 0) {
            this.userBprivateTestFolder.setObjectID(foldersB.get("UserB - findAPIPrivateTaskFolder - NA").getObjectID());
        }
        try {
            this.userBpublicTestFolder = com.openexchange.ajax.folder.Create.createPublicFolder(this.clientB, "UserB - findAPIPublicTaskFolder", 1, false);
        }
        catch (OXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.userBpublicTestFolder.getObjectID() == 0) {
            this.userBpublicTestFolder.setObjectID(foldersB.get("UserB - findAPIPublicTaskFolder").getObjectID());
        }
    }

    private final Map<String, FolderObject> getFolderStructure(AJAXClient client, int folderID) throws Exception {
        FolderObject fo;
        HashMap<String, FolderObject> folders = new HashMap<String, FolderObject>();
        VisibleFoldersRequest lr = new VisibleFoldersRequest(EnumAPI.OX_NEW, "tasks");
        VisibleFoldersResponse response = client.execute(lr);
        Iterator<FolderObject> it = response.getPrivateFolders();
        while (it.hasNext()) {
            fo = it.next();
            folders.put(fo.getFolderName(), fo);
        }
        it = response.getPublicFolders();
        while (it.hasNext()) {
            fo = it.next();
            folders.put(fo.getFolderName(), fo);
        }
        it = response.getSharedFolders();
        while (it.hasNext()) {
            fo = it.next();
            folders.put(fo.getFolderName(), fo);
        }
        return folders;
    }

    private final void createAndInsertTasks() throws Exception {
        UserParticipant usrPartA = new UserParticipant(this.userA.getUserId());
        UserParticipant usrPartB = new UserParticipant(this.userB.getUserId());
        ExternalUserParticipant extPart = new ExternalUserParticipant("foo@bar.org");
        for (Status s : Status.values()) {
            block6: for (FolderType ft : FolderType.values()) {
                switch (ft) {
                    case PUBLIC: {
                        this.insertTask(this.clientA, ft, s, this.userApublicTestFolder.getObjectID(), Collections.<Participant>emptyList(), false, false);
                        this.insertTask(this.clientB, ft, s, this.userBpublicTestFolder.getObjectID(), Collections.<Participant>emptyList(), false, false);
                        continue block6;
                    }
                    case PRIVATE: {
                        this.insertTask(this.clientA, ft, s, this.userAprivateTestFolder.getObjectID(), Collections.<Participant>emptyList(), false, false);
                        this.insertTask(this.clientB, ft, s, this.userBprivateTestFolder.getObjectID(), Collections.<Participant>emptyList(), false, false);
                        continue block6;
                    }
                    case SHARED: {
                        this.insertTask(this.clientB, ft, s, this.userBsharedTestFolderRO.getObjectID(), Collections.<Participant>emptyList(), false, false);
                        this.insertTask(this.clientB, ft, s, this.userBsharedTestFolderRW.getObjectID(), Collections.<Participant>emptyList(), false, false);
                    }
                }
            }
        }
        this.insertTask(this.clientA, FolderType.PRIVATE, Status.NOT_STARTED, this.userAprivateTestFolder.getObjectID(), Collections.<Participant>emptyList(), true, false);
        ArrayList<Participant> list = new ArrayList<Participant>();
        list.add((Participant)usrPartB);
        this.insertTask(this.clientB, FolderType.PRIVATE, Status.DEFERRED, this.userBprivateTestFolder.getObjectID(), list, false, false);
        list.add((Participant)usrPartA);
        this.rememberTask(this.userB, this.insertTask(this.clientA, FolderType.PRIVATE, Status.DONE, this.userAprivateTestFolder.getObjectID(), list, false, false));
        this.rememberTask(this.userB, this.insertTask(this.clientB, FolderType.SHARED, Status.NOT_STARTED, this.userBsharedTestFolderRO.getObjectID(), list, true, true));
        list.add((Participant)extPart);
        this.rememberTask(this.userA, this.insertTask(this.clientB, FolderType.PRIVATE, Status.IN_PROGRESS, this.userBprivateTestFolder.getObjectID(), list, true, false));
        list.clear();
        list.add((Participant)usrPartA);
        list.add((Participant)extPart);
        this.insertTask(this.clientA, FolderType.PRIVATE, Status.NOT_STARTED, this.userAprivateTestFolder.getObjectID(), list, true, false);
    }

    private final String readFile(String fileName) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR) + fileName));
        StringBuilder sb = new StringBuilder();
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            sb.append("\n");
            line = br.readLine();
        }
        if (br != null) {
            br.close();
        }
        return sb.toString();
    }

    private final void rememberTask(UserValues u, Task t) throws OXException, IOException, JSONException {
        List<Integer> list = this.rootTasks.get(u.getDefaultAddress());
        if (list == null) {
            list = new ArrayList<Integer>();
        }
        list.add(t.getObjectID());
        this.rootTasks.put(u.getDefaultAddress(), list);
    }

    private final Task insertTask(AJAXClient client, FolderType ft, Status status, int folder, List<Participant> participants, boolean attachment, boolean recurrence) throws Exception {
        StringBuilder builder = new StringBuilder();
        String title = builder.append("Find me, I am in a ").append(ft).append(" Folder - Hint User ").append(client.getValues().getDefaultAddress()).append(", trackingID: ").append(trackingID.toString()).toString();
        builder.setLength(0);
        String body = builder.append("User ").append(client.getValues().getDefaultAddress()).append("'s task in his ").append(ft).append(" folder and have status: ").append((Object)status).toString();
        Task t = Create.createWithDefaults(title, body, status.ordinal() + 1, folder);
        if (participants.size() > 0) {
            t.setParticipants(participants);
            builder.setLength(0);
            builder.append(t.getNote()).append(" and have ").append(participants.size()).append(" participants");
            t.setNote(builder.toString());
        }
        if (recurrence) {
            t.setStartDate(new Date(System.currentTimeMillis()));
            t.setInterval(1);
            t.setRecurrenceCount(10);
            t.setEndDate(new Date(System.currentTimeMillis() + 3600L));
            t.setRecurrenceType(1);
        }
        if (attachment) {
            builder.setLength(0);
            builder.append(t.getNote()).append(" and have ATTACHMENT");
            t.setNote(builder.toString());
        }
        client.execute(new InsertRequest(t, client.getValues().getTimeZone())).fillTask(t);
        if (attachment) {
            client.execute(new AttachRequest((CommonObject)t, "my cool attachment", new ByteArrayInputStream(this.readFile("attachment.base64").getBytes()), "image/jpeg"));
        }
        t = client.execute(new GetRequest(folder, t.getObjectID())).getTask(client.getValues().getTimeZone());
        this.tasks.put(t.getObjectID(), t);
        return t;
    }

    private final void createFilters() throws Exception {
        ArrayList<ActiveFacet> l = new ArrayList<ActiveFacet>(3);
        TasksFacetType type = TasksFacetType.TASK_PARTICIPANTS;
        l.add(this.createActiveFacet((FacetType)type, this.userA.getUserId(), this.createFilter("participant", Integer.toString(this.userA.getUserId()))));
        l.add(this.createActiveFacet((FacetType)type, this.userB.getUserId(), this.createFilter("participant", Integer.toString(this.userB.getUserId()))));
        l.add(this.createActiveFacet((FacetType)type, "foo@bar.org", this.createFilter("participant", "foo@bar.org")));
        this.facets.add(l);
        l = new ArrayList(5);
        type = TasksFacetType.TASK_STATUS;
        l.add(this.createActiveFacet((FacetType)type, 1, this.createFilter("status", Integer.toString(1))));
        l.add(this.createActiveFacet((FacetType)type, 2, this.createFilter("status", Integer.toString(2))));
        l.add(this.createActiveFacet((FacetType)type, 3, this.createFilter("status", Integer.toString(3))));
        l.add(this.createActiveFacet((FacetType)type, 4, this.createFilter("status", Integer.toString(4))));
        l.add(this.createActiveFacet((FacetType)type, 5, this.createFilter("status", Integer.toString(5))));
        this.facets.add(l);
        l = new ArrayList(3);
        l.add(this.createFolderTypeFacet(FolderType.PRIVATE));
        l.add(this.createFolderTypeFacet(FolderType.PUBLIC));
        l.add(this.createFolderTypeFacet(FolderType.SHARED));
        this.facets.add(l);
        l = new ArrayList(2);
        type = TasksFacetType.TASK_TYPE;
        l.add(this.createActiveFacet((FacetType)type, 0, this.createFilter("type", TaskType.SINGLE_TASK.toString().toLowerCase())));
        l.add(this.createActiveFacet((FacetType)type, 1, this.createFilter("type", TaskType.SERIES.toString().toLowerCase())));
        this.facets.add(l);
    }

    private final ActiveFacet createActiveFacet(FacetType type, int valueId, Filter filter) {
        return new ActiveFacet(type, Integer.toString(valueId), filter);
    }

    private final ActiveFacet createActiveFacet(FacetType type, String valueId, Filter filter) {
        return new ActiveFacet(type, valueId, filter);
    }

    private final ActiveFacet createFolderTypeFacet(FolderType type) {
        return this.createActiveFacet((FacetType)CommonFacetType.FOLDER_TYPE, type.getIdentifier(), new Filter(Collections.singletonList(CommonFacetType.FOLDER_TYPE.getId()), type.getIdentifier()));
    }

    private final Filter createFilter(String name, String value) {
        return new Filter(Collections.singletonList(name), value);
    }

    public void cleanup() throws Exception {
        if (this.cleanup) {
            if (this.clientA == null || this.clientB == null) {
                this.initUsers();
            }
            this.clientA.execute(new DeleteRequest((API)EnumAPI.OX_NEW, this.userAprivateTestFolder, this.userApublicTestFolder));
            this.clientB.execute(new DeleteRequest((API)EnumAPI.OX_NEW, this.userBsharedTestFolderRO, this.userBsharedTestFolderRW, this.userBprivateTestFolder, this.userBpublicTestFolder));
            FindTasksTestEnvironment.cleanRootTasks(this.clientA, this.rootTasks.get(this.userA.getDefaultAddress()));
            FindTasksTestEnvironment.cleanRootTasks(this.clientB, this.rootTasks.get(this.userB.getDefaultAddress()));
            this.logout();
        }
    }

    private static final void cleanRootTasks(AJAXClient client, List<Integer> list) throws OXException, IOException, JSONException {
        for (Integer i : list) {
            client.execute(new com.openexchange.ajax.task.actions.DeleteRequest(client.getValues().getPrivateTaskFolder(), i, new Date(System.currentTimeMillis() + 7300L)));
        }
    }

    public List<List<ActiveFacet>> getLoActiveFacets() {
        return this.facets;
    }

    public final Set<Integer> getTasksToFind() {
        return this.tasksToFind;
    }

    public static final String getTrackingID() {
        return trackingID.toString();
    }

    public static final ActiveFacet createGlobalFacet() {
        return FindTasksTestEnvironment.createGlobalFacet(trackingID.toString());
    }

    public static final ActiveFacet createGlobalFacet(String query) {
        return new ActiveFacet((FacetType)CommonFacetType.GLOBAL, "global", new Filter(Collections.singletonList("global"), query));
    }

    public Task getTask(int id) {
        return this.tasks.get(id);
    }

    private static enum Status {
        NOT_STARTED,
        IN_PROGRESS,
        DONE,
        WAITING,
        DEFERRED;

    }
}

