/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.contacts;

import com.openexchange.ajax.contact.action.AllRequest;
import com.openexchange.ajax.find.PropDocument;
import com.openexchange.ajax.find.actions.AutocompleteRequest;
import com.openexchange.ajax.find.actions.AutocompleteResponse;
import com.openexchange.ajax.find.actions.QueryRequest;
import com.openexchange.ajax.find.actions.QueryResponse;
import com.openexchange.ajax.find.contacts.ContactsFindTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.find.Document;
import com.openexchange.find.Module;
import com.openexchange.find.SearchResult;
import com.openexchange.find.common.CommonFacetType;
import com.openexchange.find.common.FolderType;
import com.openexchange.find.contacts.ContactsFacetType;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.DefaultFacet;
import com.openexchange.find.facet.ExclusiveFacet;
import com.openexchange.find.facet.Facet;
import com.openexchange.find.facet.FacetType;
import com.openexchange.find.facet.FacetValue;
import com.openexchange.find.facet.Filter;
import com.openexchange.find.facet.SimpleFacet;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.groupware.container.FolderObject;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class QueryTest
extends ContactsFindTest {
    public QueryTest(String name) {
        super(name);
    }

    public void testFilterChaining() throws Exception {
        Contact contact = this.randomContact();
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.add(this.applyMatchingFacet((FacetType)ContactsFacetType.PHONE, contact, QueryTest.randomUID(), "phone", PHONE_COLUMNS, true));
        facets.add(this.applyMatchingFacet((FacetType)ContactsFacetType.NAME, contact, QueryTest.randomUID(), "name", NAME_COLUMNS, true));
        facets.add(this.applyMatchingFacet((FacetType)ContactsFacetType.ADDRESS, contact, QueryTest.randomUID(), "address", ADDRESS_COLUMNS, true));
        facets.add(this.applyMatchingFacet((FacetType)ContactsFacetType.EMAIL, contact, QueryTest.randomUID() + "@example.org", "email", EMAIL_COLUMNS, true));
        facets.add(this.applyMatchingFacet((FacetType)CommonFacetType.GLOBAL, contact, QueryTest.randomUID(), "address_book", ADDRESSBOOK_COLUMNS, true));
        facets.add(QueryTest.createActiveFieldFacet((FacetType)ContactsFacetType.CONTACT_TYPE, "contact_type", "contact"));
        facets.add(QueryTest.createFolderTypeFacet(FolderType.PRIVATE));
        contact = this.manager.newAction(contact);
        this.assertFoundDocumentInSearch(facets, contact.getEmail1());
    }

    public void testFilterPhone() throws Exception {
        this.testStringFilter((FacetType)ContactsFacetType.PHONE, "phone", PHONE_COLUMNS);
    }

    public void testFilterName() throws Exception {
        this.testStringFilter((FacetType)ContactsFacetType.NAME, "name", NAME_COLUMNS);
    }

    public void testFilterAddressbook() throws Exception {
        this.testStringFilter((FacetType)CommonFacetType.GLOBAL, "address_book", ADDRESS_COLUMNS);
    }

    public void testFilterAddress() throws Exception {
        this.testStringFilter((FacetType)ContactsFacetType.ADDRESS, "address", ADDRESS_COLUMNS);
    }

    public void testFilterEmail() throws Exception {
        this.testStringFilter((FacetType)ContactsFacetType.EMAIL, "email", QueryTest.randomUID() + "@example.com", EMAIL_COLUMNS);
    }

    public void testFilterContactType() throws Exception {
        Contact contact = this.randomContact();
        Contact distributionList = this.randomContact();
        distributionList.setDistributionList(new DistributionListEntryObject[]{new DistributionListEntryObject(QueryTest.randomUID(), QueryTest.randomUID() + "@example.com", 0), new DistributionListEntryObject(QueryTest.randomUID(), QueryTest.randomUID() + "@example.com", 0), new DistributionListEntryObject(QueryTest.randomUID(), QueryTest.randomUID() + "@example.com", 0)});
        this.manager.newAction(contact, distributionList);
        List<PropDocument> contactDocuments = this.query(Collections.singletonList(QueryTest.createActiveFacet((FacetType)ContactsFacetType.CONTACT_TYPE, "contact", "contact_type", "contact")));
        QueryTest.assertTrue((String)"no contacts found", (0 < contactDocuments.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"contact not found", (Object)QueryTest.findByProperty(contactDocuments, "email1", contact.getEmail1()));
        QueryTest.assertNull((String)"distribution list found", (Object)QueryTest.findByProperty(contactDocuments, "display_name", distributionList.getDisplayName()));
        List<PropDocument> distListDocuments = this.query(Collections.singletonList(QueryTest.createActiveFacet((FacetType)ContactsFacetType.CONTACT_TYPE, "distribution list", "contact_type", "distribution list")));
        QueryTest.assertTrue((String)"no distribution lists found", (0 < distListDocuments.size() ? 1 : 0) != 0);
        QueryTest.assertNull((String)"contact found", (Object)QueryTest.findByProperty(distListDocuments, "email1", contact.getEmail1()));
        QueryTest.assertNotNull((String)"distribution list not found", (Object)QueryTest.findByProperty(distListDocuments, "display_name", distributionList.getDisplayName()));
    }

    public void testFilterFolderType() throws Exception {
        Contact contact = this.manager.newAction(this.randomContact());
        List<PropDocument> privateFolderDocuments = this.query(Collections.singletonList(QueryTest.createFolderTypeFacet(FolderType.PRIVATE)));
        QueryTest.assertTrue((String)"no contacts found", (0 < privateFolderDocuments.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"contact not found", (Object)QueryTest.findByProperty(privateFolderDocuments, "email1", contact.getEmail1()));
        List<PropDocument> sharedFolderDocuments = this.query(Collections.singletonList(QueryTest.createFolderTypeFacet(FolderType.SHARED)));
        QueryTest.assertNull((String)"contact found", (Object)QueryTest.findByProperty(sharedFolderDocuments, "email1", contact.getEmail1()));
        List<PropDocument> publicFolderDocuments = this.query(Collections.singletonList(QueryTest.createFolderTypeFacet(FolderType.PUBLIC)));
        QueryTest.assertNull((String)"contact found", (Object)QueryTest.findByProperty(publicFolderDocuments, "email1", contact.getEmail1()));
        QueryTest.assertNotNull((String)"user contact not found", (Object)QueryTest.findByProperty(publicFolderDocuments, "email1", this.client.getValues().getDefaultAddress()));
    }

    public void testTokenizedQuery() throws Exception {
        Contact contact = this.randomContact();
        String t1 = QueryTest.randomUID();
        String t2 = QueryTest.randomUID();
        String t3 = QueryTest.randomUID();
        contact.setSurName(t1 + " " + t2 + " " + t3);
        contact = this.manager.newAction(contact);
        SimpleFacet globalFacet = (SimpleFacet)QueryTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.CONTACTS, t1 + " " + t3));
        List<PropDocument> documents = this.query(Collections.singletonList(QueryTest.createActiveFacet(globalFacet)));
        QueryTest.assertTrue((String)"no contact found", (0 < documents.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"contact not found", (Object)QueryTest.findByProperty(documents, "last_name", contact.getSurName()));
        globalFacet = (SimpleFacet)QueryTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.CONTACTS, "\"" + t1 + " " + t2 + "\""));
        documents = this.query(Collections.singletonList(QueryTest.createActiveFacet(globalFacet)));
        QueryTest.assertTrue((String)"no contact found", (0 < documents.size() ? 1 : 0) != 0);
        QueryTest.assertNotNull((String)"contact not found", (Object)QueryTest.findByProperty(documents, "last_name", contact.getSurName()));
        globalFacet = (SimpleFacet)QueryTest.findByType((FacetType)CommonFacetType.GLOBAL, this.autocomplete(Module.CONTACTS, "\"" + t1 + " " + t3 + "\""));
        documents = this.query(Collections.singletonList(QueryTest.createActiveFacet(globalFacet)));
        QueryTest.assertTrue((String)"contact found", (0 == documents.size() ? 1 : 0) != 0);
    }

    private ActiveFacet applyMatchingFacet(FacetType type, Contact contact, String value, String filterField, int[] searchedColumns, boolean unassignedOnly) {
        if (unassignedOnly) {
            ArrayList<Integer> unassignedColumns = new ArrayList<Integer>();
            for (int column : searchedColumns) {
                if (contact.contains(column)) continue;
                unassignedColumns.add(column);
            }
            if (0 == unassignedColumns.size()) {
                QueryTest.fail((String)("no unassigned fields from " + Arrays.toString((int[])searchedColumns) + " left."));
            }
            contact.set(((Integer)unassignedColumns.get(this.random.nextInt(unassignedColumns.size()))).intValue(), (Object)value);
        } else {
            contact.set(searchedColumns[this.random.nextInt(searchedColumns.length)], (Object)value);
        }
        int start = this.random.nextInt(value.length() - 4);
        int stop = start + 4 + this.random.nextInt(value.length() - start - 4);
        String substring = value.substring(start, stop);
        return QueryTest.createActiveFacet(type, String.valueOf(contact.getObjectID()), filterField, value);
    }

    private void testStringFilter(FacetType type, String filterField, int[] searchedColumns) throws Exception {
        this.testStringFilter(type, filterField, QueryTest.randomUID(), searchedColumns);
    }

    private void testStringFilter(FacetType type, String filterField, String value, int[] searchedColumns) throws Exception {
        Contact contact = this.randomContact();
        ActiveFacet facet = this.applyMatchingFacet(type, contact, value, filterField, searchedColumns, true);
        contact = this.manager.newAction(contact);
        this.assertFoundDocumentInSearch(Collections.singletonList(facet), contact.getEmail1());
        this.assertEmptyResults(Collections.singletonList(QueryTest.createActiveFacet(type, filterField, filterField, QueryTest.randomUID())));
    }

    private PropDocument assertFoundDocumentInSearch(List<ActiveFacet> facets, String expectedEmail1) throws Exception {
        List<PropDocument> documents = this.query(facets);
        QueryTest.assertTrue((String)"No contact documents found", (0 < documents.size() ? 1 : 0) != 0);
        PropDocument document = QueryTest.findByProperty(documents, "email1", expectedEmail1);
        QueryTest.assertNotNull((String)("no document found for: " + expectedEmail1), (Object)document);
        return document;
    }

    private void assertEmptyResults(List<ActiveFacet> facets) throws Exception {
        QueryRequest queryRequest = new QueryRequest(0, 10, facets, Module.CONTACTS.getIdentifier());
        QueryResponse queryResponse = this.client.execute(queryRequest);
        SearchResult result = queryResponse.getSearchResult();
        List documents = result.getDocuments();
        QueryTest.assertEquals((String)"Documents were found", (int)0, (int)documents.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFolderTypeFacet() throws Exception {
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        try {
            FolderType[] typesInOrder = new FolderType[]{FolderType.PRIVATE, FolderType.PUBLIC, FolderType.SHARED};
            AJAXClient[] clients = new AJAXClient[]{this.client, this.client, client2};
            FolderObject[] folders = new FolderObject[]{this.folderManager.insertFolderOnServer(this.folderManager.generatePrivateFolder(QueryTest.randomUID(), 3, this.client.getValues().getPrivateContactFolder(), this.client.getValues().getUserId())), this.folderManager.insertFolderOnServer(this.folderManager.generatePublicFolder(QueryTest.randomUID(), 3, 2, this.client.getValues().getUserId())), this.folderManager.insertFolderOnServer(this.folderManager.generateSharedFolder(QueryTest.randomUID(), 3, this.client.getValues().getPrivateContactFolder(), this.client.getValues().getUserId(), client2.getValues().getUserId()))};
            Contact[] contacts = new Contact[]{this.manager.newAction(this.randomContact(folders[0].getObjectID())), this.manager.newAction(this.randomContact(folders[1].getObjectID())), this.manager.newAction(this.randomContact(folders[2].getObjectID()))};
            block8: for (int i = 0; i < 3; ++i) {
                FolderType folderType = typesInOrder[i];
                List<Facet> facets = this.autocomplete(clients[i], "");
                ExclusiveFacet folderTypeFacet = (ExclusiveFacet)QueryTest.findByType((FacetType)CommonFacetType.FOLDER_TYPE, facets);
                FacetValue typeValue = QueryTest.findByValueId(folderType.getIdentifier(), (DefaultFacet)folderTypeFacet);
                List<PropDocument> docs = this.query(clients[i], Collections.singletonList(QueryTest.createActiveFacet((DefaultFacet)folderTypeFacet, typeValue)));
                PropDocument[] foundDocs = new PropDocument[3];
                for (PropDocument doc : docs) {
                    Map<String, Object> props = doc.getProps();
                    if (contacts[0].getSurName().equals(props.get("last_name"))) {
                        foundDocs[0] = doc;
                        continue;
                    }
                    if (contacts[1].getSurName().equals(props.get("last_name"))) {
                        foundDocs[1] = doc;
                        continue;
                    }
                    if (!contacts[2].getSurName().equals(props.get("last_name"))) continue;
                    foundDocs[2] = doc;
                }
                switch (folderType) {
                    case PRIVATE: {
                        QueryTest.assertNotNull((String)"Private contact not found", (Object)foundDocs[0]);
                        QueryTest.assertNull((String)"Public contact found but should not", (Object)foundDocs[1]);
                        QueryTest.assertNotNull((String)"Shared contact not found", (Object)foundDocs[2]);
                        continue block8;
                    }
                    case PUBLIC: {
                        QueryTest.assertNull((String)"Private contact found but should not", (Object)foundDocs[0]);
                        QueryTest.assertNotNull((String)"Public contact not found", (Object)foundDocs[1]);
                        QueryTest.assertNull((String)"Shared contact found but should not", (Object)foundDocs[2]);
                        continue block8;
                    }
                    case SHARED: {
                        QueryTest.assertNull((String)"Private contact found but should not", (Object)foundDocs[0]);
                        QueryTest.assertNull((String)"Public contact found but should not", (Object)foundDocs[1]);
                        QueryTest.assertNotNull((String)"Shared contact not found", (Object)foundDocs[2]);
                    }
                }
            }
        }
        finally {
            client2.logout();
        }
    }

    public void testPaging() throws Exception {
        int numberOfContacts = this.client.execute(new AllRequest(6, AllRequest.GUI_COLUMNS)).getArray().length - 1;
        HashSet<Integer> names = new HashSet<Integer>();
        ActiveFacet folderFacet = QueryTest.createActiveFacet((FacetType)CommonFacetType.FOLDER, 6, Filter.NO_FILTER);
        int start = 0;
        int size = numberOfContacts / 2;
        Map<String, String> options = Collections.singletonMap("admin", "false");
        List<PropDocument> results = this.query(Collections.singletonList(folderFacet), start, size, options);
        QueryTest.assertEquals((String)"Wrong number of results", (int)size, (int)results.size());
        for (PropDocument result : results) {
            names.add((Integer)result.getProps().get("id"));
        }
        QueryTest.assertEquals((String)"Wrong number of unique results", (int)size, (int)names.size());
        start = size;
        size = numberOfContacts - start;
        results = this.query(Collections.singletonList(folderFacet), start, size, options);
        QueryTest.assertEquals((String)"Wrong number of results", (int)size, (int)results.size());
        for (PropDocument result : results) {
            names.add((Integer)result.getProps().get("id"));
        }
        QueryTest.assertEquals((String)"Wrong number of unique results", (int)numberOfContacts, (int)names.size());
    }

    protected List<Facet> autocomplete(AJAXClient client, String prefix) throws Exception {
        AutocompleteRequest autocompleteRequest = new AutocompleteRequest(prefix, Module.CONTACTS.getIdentifier());
        AutocompleteResponse autocompleteResponse = client.execute(autocompleteRequest);
        return autocompleteResponse.getFacets();
    }

    protected List<PropDocument> query(AJAXClient client, List<ActiveFacet> facets) throws Exception {
        QueryRequest queryRequest = new QueryRequest(0, Integer.MAX_VALUE, facets, Module.CONTACTS.getIdentifier());
        QueryResponse queryResponse = client.execute(queryRequest);
        SearchResult result = queryResponse.getSearchResult();
        ArrayList<PropDocument> propDocuments = new ArrayList<PropDocument>();
        List documents = result.getDocuments();
        for (Document document : documents) {
            propDocuments.add((PropDocument)document);
        }
        return propDocuments;
    }

    protected List<PropDocument> query(List<ActiveFacet> facets, int start, int size, Map<String, String> options) throws Exception {
        QueryRequest queryRequest = new QueryRequest(true, start, size, facets, options, Module.CONTACTS.getIdentifier(), null);
        QueryResponse queryResponse = this.client.execute(queryRequest);
        SearchResult result = queryResponse.getSearchResult();
        ArrayList<PropDocument> propDocuments = new ArrayList<PropDocument>();
        List documents = result.getDocuments();
        for (Document document : documents) {
            propDocuments.add((PropDocument)document);
        }
        return propDocuments;
    }
}

