/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.contacts;

import com.openexchange.ajax.find.AbstractFindTest;
import com.openexchange.ajax.find.PropDocument;
import com.openexchange.ajax.find.actions.AutocompleteRequest;
import com.openexchange.ajax.find.actions.AutocompleteResponse;
import com.openexchange.ajax.find.actions.QueryRequest;
import com.openexchange.ajax.find.actions.QueryResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.user.actions.GetRequest;
import com.openexchange.find.Document;
import com.openexchange.find.Module;
import com.openexchange.find.SearchResult;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.Facet;
import com.openexchange.find.facet.FacetValue;
import com.openexchange.find.util.DisplayItems;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.util.TimeZones;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class ExcludeContextAdminTest
extends AbstractFindTest {
    public ExcludeContextAdminTest(String name) {
        super(name);
    }

    public void testAdminIsExcluded() throws Exception {
        AJAXClient adminClient = new AJAXClient(AJAXClient.User.OXAdmin);
        int adminId = adminClient.getValues().getUserId();
        adminClient.logout();
        Contact adminContact = this.client.execute(new GetRequest(adminId, TimeZones.UTC)).getContact();
        ExcludeContextAdminTest.assertNotNull((String)"admin contact was null", (Object)adminContact);
        String prefix = adminContact.getDisplayName().substring(0, 3);
        List<Facet> facets = this.autocomplete(prefix, false);
        FacetValue found = ExcludeContextAdminTest.findByDisplayName(facets, adminContact.getDisplayName());
        ExcludeContextAdminTest.assertNull((String)"admin contact was included in autocomplete response", (Object)found);
        LinkedList<ActiveFacet> activeFacets = new LinkedList<ActiveFacet>();
        activeFacets.add(ExcludeContextAdminTest.createQuery(adminContact.getDisplayName()));
        List<PropDocument> documents = this.query(activeFacets, false);
        PropDocument adminDoc = ExcludeContextAdminTest.findByProperty(documents, "display_name", DisplayItems.convert((Contact)adminContact).getDisplayName());
        ExcludeContextAdminTest.assertNull((String)"admin contact was included in query response", (Object)adminDoc);
    }

    public void testAdminIsIncluded() throws Exception {
        AJAXClient adminClient = new AJAXClient(AJAXClient.User.OXAdmin);
        int adminId = adminClient.getValues().getUserId();
        adminClient.logout();
        Contact adminContact = this.client.execute(new GetRequest(adminId, TimeZones.UTC)).getContact();
        ExcludeContextAdminTest.assertNotNull((String)"admin contact was null", (Object)adminContact);
        String prefix = adminContact.getDisplayName().substring(0, 3);
        List<Facet> facets = this.autocomplete(prefix, true);
        FacetValue found = ExcludeContextAdminTest.findByDisplayName(facets, DisplayItems.convert((Contact)adminContact).getDisplayName());
        ExcludeContextAdminTest.assertNotNull((String)"admin contact was not included in autocomplete response", (Object)found);
        LinkedList<ActiveFacet> activeFacets = new LinkedList<ActiveFacet>();
        activeFacets.add(ExcludeContextAdminTest.createQuery(adminContact.getDisplayName()));
        List<PropDocument> documents = this.query(activeFacets, true);
        PropDocument adminDoc = ExcludeContextAdminTest.findByProperty(documents, "display_name", adminContact.getDisplayName());
        ExcludeContextAdminTest.assertNotNull((String)"admin contact was not included in query response", (Object)adminDoc);
    }

    protected List<PropDocument> query(List<ActiveFacet> facets, boolean showAdmin) throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("admin", Boolean.toString(showAdmin));
        QueryRequest queryRequest = new QueryRequest(true, 0, Integer.MAX_VALUE, facets, options, Module.CONTACTS.getIdentifier(), null);
        QueryResponse queryResponse = this.client.execute(queryRequest);
        SearchResult result = queryResponse.getSearchResult();
        ArrayList<PropDocument> propDocuments = new ArrayList<PropDocument>();
        List documents = result.getDocuments();
        for (Document document : documents) {
            propDocuments.add((PropDocument)document);
        }
        return propDocuments;
    }

    private List<Facet> autocomplete(String prefix, boolean showAdmin) throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("admin", Boolean.toString(showAdmin));
        AutocompleteRequest autocompleteRequest = new AutocompleteRequest(prefix, Module.CONTACTS.getIdentifier(), options);
        AutocompleteResponse autocompleteResponse = this.client.execute(autocompleteRequest);
        return autocompleteResponse.getFacets();
    }
}

