/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.calendar;

import com.openexchange.ajax.find.AbstractFindTest;
import com.openexchange.ajax.find.PropDocument;
import com.openexchange.find.Module;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class CalendarFindTest
extends AbstractFindTest {
    protected CalendarTestManager manager;
    protected Random random;
    protected CalendarTestManager manager2;

    public CalendarFindTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.random = new Random();
        this.manager = new CalendarTestManager(this.client);
        this.manager2 = new CalendarTestManager(this.client2);
    }

    @Override
    public void tearDown() throws Exception {
        this.manager.cleanUp();
        this.manager2.cleanUp();
        super.tearDown();
    }

    protected Appointment randomPrivateAppointment() throws Exception {
        Appointment app = new Appointment();
        app.setTitle(CalendarFindTest.randomUID());
        app.setLocation(CalendarFindTest.randomUID());
        app.setNote(CalendarFindTest.randomUID());
        app.setStartDate(TimeTools.D("Next friday at 10:15"));
        app.setEndDate(TimeTools.D("Next friday at 11:30"));
        app.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        app.setIgnoreConflicts(true);
        return app;
    }

    protected Appointment randomAppointment(int parentFolder) throws Exception {
        Appointment app = new Appointment();
        app.setTitle(CalendarFindTest.randomUID());
        app.setLocation(CalendarFindTest.randomUID());
        app.setNote(CalendarFindTest.randomUID());
        app.setStartDate(TimeTools.D("Next friday at 10:15"));
        app.setEndDate(TimeTools.D("Next friday at 11:30"));
        app.setParentFolderID(parentFolder);
        app.setIgnoreConflicts(true);
        return app;
    }

    protected List<PropDocument> query(List<ActiveFacet> facets) throws Exception {
        return this.query(Module.CALENDAR, facets);
    }

    protected List<PropDocument> query(List<ActiveFacet> facets, Map<String, String> options) throws Exception {
        return this.query(Module.CALENDAR, facets, options);
    }
}

