/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractContactTest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.test.OXTestToolkit;
import java.util.Date;
import org.json.JSONObject;

public class UpdateTest
extends AbstractContactTest {
    public UpdateTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testUpdate() throws Exception {
        Contact contactObj = this.createContactObject("testUpdate");
        int objectId = this.insertContact(contactObj);
        contactObj.setObjectID(objectId);
        contactObj.setTelephoneBusiness1("+49009988776655");
        contactObj.setStateBusiness(null);
        contactObj.removeParentFolderID();
        this.updateContact(contactObj, this.contactFolderId);
    }

    public void testUpdateWithDistributionList() throws Exception {
        Contact contactEntry = this.createContactObject("internal contact");
        contactEntry.setEmail1("internalcontact@x.de");
        int contactId = this.insertContact(contactEntry);
        contactEntry.setObjectID(contactId);
        int objectId = this.createContactWithDistributionList("testUpdateWithDistributionList", contactEntry);
        GetRequest getRequest = new GetRequest(this.contactFolderId, objectId, this.tz, false);
        GetResponse getResponse = this.client.execute(getRequest);
        Date lastModified = new Date(((JSONObject)getResponse.getData()).getLong("last_modified"));
        Contact contactObj = new Contact();
        contactObj.setSurName("testUpdateWithDistributionList");
        contactObj.setParentFolderID(this.contactFolderId);
        contactObj.setObjectID(objectId);
        contactObj.setLastModified(lastModified);
        DistributionListEntryObject[] entry = new DistributionListEntryObject[]{new DistributionListEntryObject("displayname a", "a@a.de", 0), new DistributionListEntryObject("displayname b", "b@b.de", 0)};
        contactObj.setDistributionList(entry);
        contactObj.removeParentFolderID();
        this.updateContact(contactObj, this.contactFolderId);
    }

    public void testContactWithImage() throws Exception {
        Contact contactObj = this.createContactObject("testContactWithImage");
        contactObj.setImage1(image);
        contactObj.setImageContentType("image/png");
        int objectId = this.insertContact(contactObj);
        GetRequest request = new GetRequest(this.contactFolderId, objectId, this.tz);
        GetResponse response = this.client.execute(request);
        String imageUrl = response.getImageUrl();
        if (imageUrl == null) {
            UpdateTest.fail((String)"Contact contains no image URL.");
        }
        byte[] b = this.loadImageByURL(this.client.getProtocol(), this.client.getHostname(), imageUrl);
        OXTestToolkit.assertImageBytesEqualsAndNotNull("image", contactObj.getImage1(), b);
    }

    public void testUpdateContactWithImage() throws Exception {
        Contact contactObj = this.createContactObject("testUpdateContactWithImageUpdate");
        int objectId = this.insertContact(contactObj);
        contactObj.setImage1(image);
        contactObj.setImageContentType("image/png");
        contactObj.removeParentFolderID();
        this.updateContact(contactObj, this.contactFolderId);
        GetRequest request = new GetRequest(this.contactFolderId, objectId, this.tz);
        GetResponse response = this.client.execute(request);
        String imageUrl = response.getImageUrl();
        if (imageUrl == null) {
            UpdateTest.fail((String)"Contact contains no image URL.");
        }
        byte[] b = this.loadImageByURL(this.client.getProtocol(), this.client.getHostname(), imageUrl);
        OXTestToolkit.assertImageBytesEqualsAndNotNull("image", contactObj.getImage1(), b);
    }
}

