/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import java.util.ArrayList;

public class Bug28185Test
extends AbstractManagedContactTest {
    public Bug28185Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testWrongMemberReference() throws OXException {
        Contact distributionList = super.generateContact("List");
        ArrayList<DistributionListEntryObject> members = new ArrayList<DistributionListEntryObject>();
        DistributionListEntryObject member = new DistributionListEntryObject();
        member.setEntryID(98967896);
        members.add(member);
        distributionList.setDistributionList(members.toArray(new DistributionListEntryObject[0]));
        this.manager.newAction(distributionList);
        Bug28185Test.assertFalse((String)"contact has an object ID", (0 < distributionList.getObjectID() ? 1 : 0) != 0);
        OXException lastException = this.manager.getLastResponse().getException();
        Bug28185Test.assertNotNull((String)"no exception thrown", (Object)((Object)lastException));
        Bug28185Test.assertEquals((String)"unexpected error code in exception", (String)"CON-0177", (String)lastException.getErrorCode());
    }

    public void testEmptyEmailAddress() throws OXException {
        Contact distributionList = super.generateContact("List");
        ArrayList<DistributionListEntryObject> members = new ArrayList<DistributionListEntryObject>();
        DistributionListEntryObject member = new DistributionListEntryObject();
        member.setEmailaddress("", false);
        members.add(member);
        distributionList.setDistributionList(members.toArray(new DistributionListEntryObject[0]));
        this.manager.newAction(distributionList);
        Bug28185Test.assertFalse((String)"contact has an object ID", (0 < distributionList.getObjectID() ? 1 : 0) != 0);
        OXException lastException = this.manager.getLastResponse().getException();
        Bug28185Test.assertNotNull((String)"no exception thrown", (Object)((Object)lastException));
        Bug28185Test.assertEquals((String)"unexpected error code in exception", (String)"CON-0177", (String)lastException.getErrorCode());
    }

    public void testNoObjectIDReference() throws OXException {
        Contact distributionList = super.generateContact("List");
        ArrayList<DistributionListEntryObject> members = new ArrayList<DistributionListEntryObject>();
        DistributionListEntryObject member = new DistributionListEntryObject();
        member.setEmailfield(1);
        members.add(member);
        distributionList.setDistributionList(members.toArray(new DistributionListEntryObject[0]));
        this.manager.newAction(distributionList);
        Bug28185Test.assertFalse((String)"contact has an object ID", (0 < distributionList.getObjectID() ? 1 : 0) != 0);
        OXException lastException = this.manager.getLastResponse().getException();
        Bug28185Test.assertNotNull((String)"no exception thrown", (Object)((Object)lastException));
        Bug28185Test.assertEquals((String)"unexpected error code in exception", (String)"CON-0178", (String)lastException.getErrorCode());
    }
}

