/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.config;

import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.GetResponse;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.RandomString;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionTests
extends AbstractAJAXSession {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionTests.class);
    private AJAXClient client;
    private static final long MAX_DIFFERENCE = 1000L;

    public FunctionTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    public void testMaxUploadIdleTimeout() throws Throwable {
        int value = this.client.execute(new GetRequest(Tree.MaxUploadIdleTimeout)).getInteger();
        LOG.info("Max upload idle timeout: {}", (Object)value);
        FunctionTests.assertTrue((String)"Got no value for the maxUploadIdleTimeout configuration parameter.", (value > 0 ? 1 : 0) != 0);
    }

    public void testCurrentTime() throws Throwable {
        GetRequest request = new GetRequest(Tree.CurrentTime);
        GetResponse response = Executor.execute(this.client, request);
        long firstServerTime = response.getLong();
        int randomWait = new Random(System.currentTimeMillis()).nextInt(10000);
        Thread.sleep(randomWait);
        GetRequest request2 = new GetRequest(Tree.CurrentTime);
        GetResponse response2 = Executor.execute(this.client, request2);
        long secondServerTime = response2.getLong();
        long totalDuration = response2.getTotalDuration();
        Date sTime = this.client.getValues().getServerTime();
        long localTime = System.currentTimeMillis();
        LOG.info("Local time: " + localTime + " Server time: " + sTime.getTime());
        long difference = Math.abs(secondServerTime - totalDuration - (long)randomWait - firstServerTime);
        LOG.info("Time difference: " + difference);
        FunctionTests.assertTrue((String)("Too big time difference: " + difference), (difference < 1000L ? 1 : 0) != 0);
    }

    public void testContextID() throws Throwable {
        int value = this.client.execute(new GetRequest(Tree.ContextID)).getInteger();
        LOG.info("Context identifier: " + value);
        FunctionTests.assertTrue((String)"Got no value for the contextID configuration parameter.", (value > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGUI() throws Throwable {
        GetResponse origGet = this.client.execute(new GetRequest(Tree.GUI));
        String testValue = RandomString.generateChars(20);
        try {
            this.client.execute(new SetRequest(Tree.GUI, testValue));
            GetResponse testGet = this.client.execute(new GetRequest(Tree.GUI));
            FunctionTests.assertEquals((String)"Written GUI value differs from read one.", (String)testValue, (String)testGet.getString());
        }
        finally {
            this.client.execute(new SetRequest(Tree.GUI, origGet.getData()));
        }
    }

    public void testConfigJumpFlag() throws Throwable {
        GetResponse get = this.client.execute(new GetRequest(Tree.Extras));
        LOG.info("Should extras link be displayed: " + get.getBoolean());
    }

    public void testShowParticipantsDialogFlag() throws Throwable {
        GetResponse get = this.client.execute(new GetRequest(Tree.ShowParticipantDialog));
        LOG.info("Should participant dialog be displayed: " + get.getBoolean());
    }

    public void testAutoSearchFlag() throws Throwable {
        GetResponse get = this.client.execute(new GetRequest(Tree.ParticipantAutoSearch));
        LOG.info("Is search triggered on opened participant dialog: " + get.getBoolean());
    }

    public void testShowWithoutEmailFlag() throws Throwable {
        GetResponse get = this.client.execute(new GetRequest(Tree.ShowWithoutEmail));
        LOG.info("Are external participants without email address shown in participant dialog: " + get.getBoolean());
    }

    public void testMailAddressAutoSearchFlag() throws Throwable {
        GetResponse get = this.client.execute(new GetRequest(Tree.MailAddressAutoSearch));
        LOG.info("Is search triggered on opened recipient dialog: " + get.getBoolean());
    }

    public void testMinimumSearchCharacters() throws Throwable {
        GetResponse response = this.client.execute(new GetRequest(Tree.MinimumSearchCharacters));
        LOG.info("Minimum of characters for a search pattern: " + response.getInteger());
    }

    public void testMaximumNumberParticipants() throws Throwable {
        GetResponse response = this.client.execute(new GetRequest(Tree.MAXIMUM_NUMBER_PARTICIPANTS));
        LOG.info("Maximum number of participants for appointments and tasks: " + response.getInteger());
    }

    public void testSingleFolderSearch() throws Throwable {
        GetResponse response = this.client.execute(new GetRequest(Tree.SingleFolderSearch));
        LOG.info("User is only allowed to search in a single folder: " + response.getBoolean());
    }

    public void testNotifySwitches() throws Throwable {
        for (Tree param : new Tree[]{Tree.CalendarNotifyNewModifiedDeleted, Tree.CalendarNotifyNewAcceptedDeclinedAsCreator, Tree.CalendarNotifyNewAcceptedDeclinedAsParticipant, Tree.TasksNotifyNewModifiedDeleted, Tree.TasksNotifyNewAcceptedDeclinedAsCreator, Tree.TasksNotifyNewAcceptedDeclinedAsParticipant}) {
            this.testBoolean(param, true);
        }
    }

    public void testCharacterSearch() throws Throwable {
        GetResponse response = this.client.execute(new GetRequest(Tree.CharacterSearch));
        LOG.info("User is only allowed to search via character side bar in contacts: " + response.getBoolean());
    }

    public void testAllFolderForAutoComplete() throws Throwable {
        GetResponse response = this.client.execute(new GetRequest(Tree.AllFolderForAutoComplete));
        LOG.info("User is allowed to search via auto complete in all folders: " + response.getBoolean());
    }

    public void testFolderTree() throws Throwable {
        int defaultValue = this.client.execute(new GetRequest(Tree.FolderTree)).getInteger();
        this.client.execute(new SetRequest(Tree.FolderTree, Autoboxing.I((int)0)));
        FunctionTests.assertEquals((String)"Selecting OX folder tree did not work.", (int)0, (int)this.client.execute(new GetRequest(Tree.FolderTree)).getInteger());
        this.client.execute(new SetRequest(Tree.FolderTree, Autoboxing.I((int)1)));
        FunctionTests.assertEquals((String)"Selecting new Outlook folder tree did not work.", (int)1, (int)this.client.execute(new GetRequest(Tree.FolderTree)).getInteger());
        this.client.execute(new SetRequest(Tree.FolderTree, Autoboxing.I((int)defaultValue)));
    }

    public void testAvailableTimeZones() throws Throwable {
        GetResponse response = this.client.execute(new GetRequest(Tree.AvailableTimeZones));
        JSONObject json = response.getJSON();
        for (Map.Entry entry : json.entrySet()) {
            LOG.info("Time zone: " + (String)entry.getKey() + ", localized name: " + entry.getValue());
        }
    }

    public void testOLOX20Module() throws Throwable {
        GetResponse response = this.client.execute(new GetRequest(Tree.OLOX20Module));
        FunctionTests.assertFalse((String)"Module for OLOX20 must be always false to prevent UI plugin loading.", (boolean)response.getBoolean());
    }

    public void testOLOX20Active() throws Throwable {
        GetResponse response = this.client.execute(new GetRequest(Tree.OLOX20Active));
        LOG.info("Is the user allowed to use OXtender for Microsoft Outlook 2: " + response.getBoolean());
    }

    private void testBoolean(Tree param, boolean testWrite) throws Throwable {
        boolean oldValue = this.client.execute(new GetRequest(param)).getBoolean();
        if (testWrite) {
            this.testWriteTrue(param);
            this.testWriteFalse(param);
            this.client.execute(new SetRequest(param, oldValue));
        }
    }

    private void testWriteTrue(Tree param) throws Throwable {
        this.client.execute(new SetRequest(param, Boolean.TRUE));
        FunctionTests.assertTrue((boolean)this.client.execute(new GetRequest(param)).getBoolean());
    }

    private void testWriteFalse(Tree param) throws Throwable {
        this.client.execute(new SetRequest(param, Boolean.FALSE));
        FunctionTests.assertFalse((boolean)this.client.execute(new GetRequest(param)).getBoolean());
    }
}

