/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.attach;

import com.openexchange.ajax.attach.actions.AllRequest;
import com.openexchange.ajax.attach.actions.AllResponse;
import com.openexchange.ajax.attach.actions.AttachRequest;
import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.search.Order;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug26544Test {
    private AJAXClient client;
    private Contact contactA;
    private TimeZone tz;

    @Before
    public void setUp() throws Exception {
        this.client = new AJAXClient(AJAXClient.User.User1);
        this.tz = this.client.getValues().getTimeZone();
        int folderId = this.client.getValues().getPrivateContactFolder();
        this.contactA = new Contact();
        this.contactA.setDisplayName("Test for bug 26544");
        this.contactA.setParentFolderID(folderId);
        this.client.execute(new InsertRequest(this.contactA)).fillObject((DataObject)this.contactA);
        this.client.execute(new AttachRequest((CommonObject)this.contactA, "C.txt", new ByteArrayInputStream("Test C".getBytes()), "text/plain")).getId();
        this.client.execute(new AttachRequest((CommonObject)this.contactA, "A.txt", new ByteArrayInputStream("Test A".getBytes()), "text/plain")).getId();
        this.client.execute(new AttachRequest((CommonObject)this.contactA, "B.txt", new ByteArrayInputStream("Test B".getBytes()), "text/plain")).getId();
        this.contactA = this.client.execute(new GetRequest(this.contactA, this.tz)).getContact();
        this.contactA.getLastModifiedOfNewestAttachment().getTime();
    }

    @After
    public void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.contactA));
        this.client.logout();
    }

    @Test
    public void testAllRequestWithSortOrder() throws OXException, IOException, JSONException {
        AJAXClient client = new AJAXClient(AJAXClient.User.User1);
        int[] cols = new int[]{800, 801, 802, 803, 804, 805, 806};
        AllRequest allRequest = new AllRequest((CommonObject)this.contactA, cols, 1, Order.ASCENDING);
        AllResponse allResponse = client.execute(allRequest);
        List<AttachmentMetadata> attachmentMetadata = allResponse.getAttachments();
        Assert.assertEquals((String)"Incorrect amount of attachments", (long)3L, (long)attachmentMetadata.size());
        Assert.assertEquals((String)"Wrong sort order", (Object)"C.txt", (Object)attachmentMetadata.get(0).getFilename());
        Assert.assertEquals((String)"Wrong sort order", (Object)"A.txt", (Object)attachmentMetadata.get(1).getFilename());
        Assert.assertEquals((String)"Wrong sort order", (Object)"B.txt", (Object)attachmentMetadata.get(2).getFilename());
        allRequest = new AllRequest((CommonObject)this.contactA, cols, 803, Order.ASCENDING);
        allResponse = client.execute(allRequest);
        attachmentMetadata = allResponse.getAttachments();
        Assert.assertEquals((String)"Incorrect amount of attachments", (long)3L, (long)attachmentMetadata.size());
        Assert.assertEquals((String)"Wrong sort order", (Object)"A.txt", (Object)attachmentMetadata.get(0).getFilename());
        Assert.assertEquals((String)"Wrong sort order", (Object)"B.txt", (Object)attachmentMetadata.get(1).getFilename());
        Assert.assertEquals((String)"Wrong sort order", (Object)"C.txt", (Object)attachmentMetadata.get(2).getFilename());
    }

    @Test
    public void testAllRequestWithoutSortOrder() throws OXException, IOException, JSONException {
        AJAXClient client = new AJAXClient(AJAXClient.User.User1);
        int[] cols = new int[]{800, 801, 802, 803, 804, 805, 806};
        AllRequest allRequest = new AllRequest((CommonObject)this.contactA, cols);
        AllResponse allResponse = client.execute(allRequest);
        List<AttachmentMetadata> attachmentMetadata = allResponse.getAttachments();
        Assert.assertEquals((String)"Incorrect amount of attachments", (long)3L, (long)attachmentMetadata.size());
        Assert.assertEquals((String)"Wrong sort order", (Object)"C.txt", (Object)attachmentMetadata.get(0).getFilename());
        Assert.assertEquals((String)"Wrong sort order", (Object)"A.txt", (Object)attachmentMetadata.get(1).getFilename());
        Assert.assertEquals((String)"Wrong sort order", (Object)"B.txt", (Object)attachmentMetadata.get(2).getFilename());
    }
}

