/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.helper;

import com.openexchange.ajax.appointment.helper.AbstractAssertion;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Changes;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.Expectations;
import com.openexchange.test.CalendarTestManager;
import java.util.List;

public abstract class AbstractPositiveAssertion
extends AbstractAssertion {
    public AbstractPositiveAssertion(CalendarTestManager manager, int folder) {
        this.manager = manager;
        this.folder = folder;
    }

    public void check(Changes changes, Expectations expectations) throws Exception {
        this.approachUsedForTest = null;
        this.check(AbstractPositiveAssertion.generateDefaultAppointment(), changes, expectations);
    }

    public abstract void check(Appointment var1, Changes var2, Expectations var3) throws Exception;

    protected void createAndUpdateAndCheck(Appointment startAppointment, Changes changes, Expectations expectations) {
        this.approachUsedForTest = "Create, then update";
        Appointment copy = startAppointment.clone();
        this.create(copy);
        this.update(copy, changes);
        this.checkViaGet(copy.getParentFolderID(), copy.getObjectID(), expectations);
        this.checkViaList(copy.getParentFolderID(), copy.getObjectID(), expectations);
    }

    protected void updateAndCheck(Appointment startAppointment, Changes changes, Expectations expectations) {
        if (null == this.approachUsedForTest) {
            this.approachUsedForTest = "Update existing";
        }
        Appointment base = new Appointment();
        base.setLastModified(startAppointment.getLastModified());
        base.setObjectID(startAppointment.getObjectID());
        base.setParentFolderID(startAppointment.getParentFolderID());
        this.update(base, changes);
        this.checkViaGet(base.getParentFolderID(), base.getObjectID(), expectations);
        this.checkViaList(base.getParentFolderID(), base.getObjectID(), expectations);
    }

    protected void createAndCheck(Appointment startAppointment, Changes changes, Expectations expectations) {
        this.approachUsedForTest = "Create directly";
        Appointment copy = startAppointment.clone();
        changes.update((CommonObject)copy);
        this.create(copy);
        if (this.manager.hasLastException()) {
            this.fail2("Could not create appointment, error: " + this.manager.getLastException());
        }
        this.checkViaGet(copy.getParentFolderID(), copy.getObjectID(), expectations);
        this.checkViaList(copy.getParentFolderID(), copy.getObjectID(), expectations);
    }

    protected void checkViaList(int folderId, int appointmentId, Expectations expectations) {
        this.methodUsedForTest = "List";
        try {
            List<Appointment> appointments = this.manager.list(new ListIDs(folderId, appointmentId), expectations.getKeys());
            Appointment actual = this.find(appointments, folderId, appointmentId);
            if (this.manager.hasLastException()) {
                this.fail2("Exception occured: " + this.manager.getLastException(), this.manager.getLastException());
            }
            expectations.verify(this.state(), (CommonObject)actual);
        }
        catch (Exception e) {
            this.fail2("Exception occurred: ", e);
            return;
        }
    }

    protected void checkViaGet(int folderId, int appointmentId, Expectations expectations) {
        Appointment actual;
        this.methodUsedForTest = "Get";
        try {
            actual = this.manager.get(folderId, appointmentId);
            if (this.manager.hasLastException()) {
                this.fail2("Exception occured: " + this.manager.getLastException());
            }
        }
        catch (Exception e) {
            this.fail2("Exception occurred: " + e);
            return;
        }
        expectations.verify(this.state(), (CommonObject)actual);
    }

    protected void checkViaGet(int folderId, int appointmentId, int recurrencePos, Expectations expectations) {
        Appointment actual;
        this.methodUsedForTest = "Get recurrence";
        try {
            actual = this.manager.get(folderId, appointmentId, recurrencePos);
            if (this.manager.hasLastException()) {
                this.fail2("Exception occured: " + this.manager.getLastException());
            }
        }
        catch (Exception e) {
            this.fail2("Exception occurred: " + e);
            return;
        }
        expectations.verify(this.state(), (CommonObject)actual);
    }
}

