/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.CalendarTestManager;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.junit.Test;

public class Bug32385Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;
    private Appointment appointment;
    private AJAXClient client1;
    private AJAXClient client2;

    public Bug32385Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.getClient());
        this.client1 = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        FolderObject sharedFolder = new FolderObject();
        sharedFolder.setObjectID(this.client2.getValues().getPrivateAppointmentFolder());
        sharedFolder.setLastModified(new Date(Long.MAX_VALUE));
        sharedFolder.setPermissionsAsArray(new OCLPermission[]{Create.ocl(this.client1.getValues().getUserId(), false, false, 128, 128, 128, 128), Create.ocl(this.client2.getValues().getUserId(), false, true, 128, 128, 128, 128)});
        CommonInsertResponse response = this.client2.execute(new UpdateRequest(EnumAPI.OX_OLD, sharedFolder));
        response.fillObject((DataObject)sharedFolder);
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 32385 Test");
        this.appointment.setStartDate(TimeTools.D("01.05.2014 08:00"));
        this.appointment.setEndDate(TimeTools.D("01.05.2014 09:00"));
        UserParticipant user1 = new UserParticipant(this.client1.getValues().getUserId());
        UserParticipant user2 = new UserParticipant(this.client2.getValues().getUserId());
        this.appointment.setParticipants(new Participant[]{user1, user2});
        this.appointment.setUsers(new UserParticipant[]{user1, user2});
        this.appointment.setParentFolderID(this.client1.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        this.ctm.insert(this.appointment);
    }

    @Test
    public void testBug32385() throws Exception {
        List<Appointment> newappointments = this.ctm.newappointments(TimeTools.D("01.05.2014 00:00", TimeZone.getTimeZone("UTC")), TimeTools.D("02.05.2014 00:00", TimeZone.getTimeZone("UTC")), 999, new int[]{1, 20});
        int count = 0;
        String inFolder = "";
        for (Appointment app : newappointments) {
            if (app.getObjectID() != this.appointment.getObjectID()) continue;
            ++count;
            inFolder = inFolder + app.getParentFolderID() + ",";
        }
        Bug32385Test.assertEquals((String)("Wrong amount of appointments found (in Folder " + inFolder + ")"), (int)1, (int)count);
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        super.tearDown();
    }
}

