/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.util.Date;
import org.junit.Test;

public class Bug29133Test
extends AbstractAJAXSession {
    private CalendarTestManager ctmA;
    private CalendarTestManager ctmB;
    private Appointment appointmentA;
    private Appointment appointmentB;
    private AJAXClient clientA;
    private AJAXClient clientB;

    public Bug29133Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clientA = this.getClient();
        this.clientB = new AJAXClient(AJAXClient.User.User2);
        this.ctmA = new CalendarTestManager(this.clientA);
        this.ctmB = new CalendarTestManager(this.clientB);
        this.appointmentA = new Appointment();
        this.appointmentA.setTitle("Bug 29133 Test");
        this.appointmentA.setStartDate(TimeTools.D("14.10.2013 08:00"));
        this.appointmentA.setEndDate(TimeTools.D("14.10.2013 09:00"));
        this.appointmentA.setRecurrenceType(2);
        this.appointmentA.setDays(4);
        this.appointmentA.setInterval(1);
        this.appointmentA.setIgnoreConflicts(true);
        this.appointmentA.setParentFolderID(this.clientA.getValues().getPrivateAppointmentFolder());
        this.appointmentA.setUsers(new UserParticipant[]{new UserParticipant(this.clientA.getValues().getUserId()), new UserParticipant(this.clientB.getValues().getUserId())});
        this.appointmentA.setParticipants(new Participant[]{new UserParticipant(this.clientA.getValues().getUserId()), new UserParticipant(this.clientB.getValues().getUserId())});
        this.ctmA.insert(this.appointmentA);
        this.appointmentB = this.ctmA.createIdentifyingCopy(this.appointmentA);
        this.appointmentB.setParentFolderID(this.clientB.getValues().getPrivateAppointmentFolder());
    }

    @Test
    public void testBug29133() throws Exception {
        this.ctmB.confirm(this.appointmentB, 1, "message");
        this.checkStatus();
        this.ctmA.confirm(this.appointmentA, 1, "message");
        this.checkStatus();
        Appointment update = this.ctmA.createIdentifyingCopy(this.appointmentA);
        update.setAlarm(30);
        update.setLastModified(new Date(Long.MAX_VALUE));
        this.ctmA.update(update);
        this.checkStatus();
    }

    private void checkStatus() throws Exception {
        Appointment load = this.ctmA.get(this.appointmentA);
        Bug29133Test.assertEquals((String)"Wrong amount of users.", (int)2, (int)load.getUsers().length);
        Bug29133Test.assertEquals((String)"Wrong confirm status.", (int)1, (int)load.getUsers()[0].getConfirm());
        Bug29133Test.assertEquals((String)"Wrong confirm status.", (int)1, (int)load.getUsers()[1].getConfirm());
    }

    @Override
    public void tearDown() throws Exception {
        this.ctmA.cleanUp();
        super.tearDown();
    }
}

