/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import java.util.GregorianCalendar;

public class Bug17264Test
extends AbstractAJAXSession {
    private AJAXClient clientA;
    private AJAXClient clientB;
    private FolderObject folder;
    private Appointment appointment;

    public Bug17264Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clientA = this.getClient();
        this.clientB = new AJAXClient(AJAXClient.User.User2);
        this.folder = Create.folder(1, "Folder to test bug 17264", 2, 1, Create.ocl(this.clientA.getValues().getUserId(), false, true, 128, 128, 128, 128), Create.ocl(this.clientB.getValues().getUserId(), false, false, 128, 128, 128, 128));
        CommonInsertResponse response = this.clientA.execute(new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_OLD, this.folder));
        response.fillObject((DataObject)this.folder);
        this.appointment = new Appointment();
        this.appointment.setUsers(new UserParticipant[]{new UserParticipant(this.clientA.getValues().getUserId()), new UserParticipant(this.clientB.getValues().getUserId())});
        this.appointment.setParticipants(new Participant[]{new UserParticipant(this.clientA.getValues().getUserId()), new UserParticipant(this.clientB.getValues().getUserId())});
        GregorianCalendar cal = new GregorianCalendar();
        int thisYear = cal.get(1);
        this.appointment.setStartDate(TimeTools.D("01.12." + Integer.toString(thisYear + 1) + " 08:00"));
        this.appointment.setEndDate(TimeTools.D("01.12." + Integer.toString(thisYear + 1) + " 09:00"));
        this.appointment.setTitle("Bug 17264 Test");
        this.appointment.setParentFolderID(this.folder.getObjectID());
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setAlarm(30);
    }

    public void testBug17264() throws Exception {
        InsertRequest insertRequest = new InsertRequest(this.appointment, this.clientA.getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.clientA.execute(insertRequest);
        insertResponse.fillObject((DataObject)this.appointment);
        this.checkAlarm(30, 0);
        this.appointment.setAlarm(60);
        this.appointment.setParentFolderID(this.folder.getObjectID());
        UpdateRequest updateRequest = new UpdateRequest(this.appointment, this.clientA.getValues().getTimeZone());
        UpdateResponse updateResponse = this.clientA.execute(updateRequest);
        updateResponse.fillObject((DataObject)this.appointment);
        this.checkAlarm(60, 0);
        this.appointment.setAlarm(120);
        this.appointment.setParentFolderID(this.folder.getObjectID());
        updateRequest = new UpdateRequest(this.appointment, this.clientB.getValues().getTimeZone());
        updateResponse = this.clientB.execute(updateRequest);
        updateResponse.fillObject((DataObject)this.appointment);
        this.checkAlarm(120, 0);
        this.appointment.setAlarm(5);
        this.appointment.setParentFolderID(this.clientB.getValues().getPrivateAppointmentFolder());
        updateRequest = new UpdateRequest(this.appointment, this.clientB.getValues().getTimeZone());
        updateResponse = this.clientB.execute(updateRequest);
        updateResponse.fillObject((DataObject)this.appointment);
        this.checkAlarm(120, 5);
    }

    public void testShareCreate() throws Exception {
        this.appointment.removeObjectID();
        this.appointment.setParentFolderID(this.folder.getObjectID());
        this.appointment.setAlarm(240);
        InsertRequest insertRequest = new InsertRequest(this.appointment, this.clientB.getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.clientB.execute(insertRequest);
        insertResponse.fillObject((DataObject)this.appointment);
        this.checkAlarm(240, 0);
    }

    private void checkAlarm(int alarmA, int alarmB) throws Exception {
        this.checkAlarm(this.clientA, this.folder.getObjectID(), alarmA);
        this.checkAlarm(this.clientB, this.folder.getObjectID(), alarmA);
    }

    private void checkAlarm(AJAXClient client, int folderId, int alarm) throws Exception {
        GetRequest getRequest = new GetRequest(folderId, this.appointment.getObjectID());
        GetResponse getResponse = client.execute(getRequest);
        Appointment app = getResponse.getAppointment(client.getValues().getTimeZone());
        Bug17264Test.assertEquals((String)"Wrong alarm value", (int)alarm, (int)app.getAlarm());
    }

    @Override
    public void tearDown() throws Exception {
        this.clientA.execute(new DeleteRequest((API)EnumAPI.OX_OLD, this.folder));
        super.tearDown();
    }
}

