/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.FolderTools;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.reminder.ReminderTools;
import com.openexchange.ajax.reminder.actions.RangeRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.server.impl.OCLPermission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class Bug16211Test
extends AbstractAJAXSession {
    private FolderObject personalAppointmentFolder;
    private FolderObject sharedAppointmentFolder;
    private Appointment appointment;
    private AJAXClient client2;
    private AJAXClient client3;
    private Calendar calendar;
    private TimeZone tz;

    public Bug16211Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.client3 = new AJAXClient(AJAXClient.User.User3);
        this.tz = this.client.getValues().getTimeZone();
        this.calendar = TimeTools.createCalendar(this.tz);
        this.sharedAppointmentFolder = Create.createPublicFolder(this.client2, "Bug16211PublicFolder" + System.currentTimeMillis(), 2);
        FolderTools.shareFolder(this.client2, EnumAPI.OX_NEW, this.sharedAppointmentFolder.getObjectID(), this.client.getValues().getUserId(), 128, 128, 128, 128);
        this.appointment = this.createAppointment();
        this.personalAppointmentFolder = Create.createPrivateFolder("Bug16211PersonalFolder", 2, this.client.getValues().getUserId(), new OCLPermission[0]);
        this.personalAppointmentFolder.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        com.openexchange.ajax.folder.actions.InsertRequest insertFolderReq = new com.openexchange.ajax.folder.actions.InsertRequest(EnumAPI.OX_NEW, this.personalAppointmentFolder, false);
        InsertResponse insertFolderResp = this.client.execute(insertFolderReq);
        insertFolderResp.fillObject((DataObject)this.personalAppointmentFolder);
    }

    public void testMoveToPersonalFolder() throws Exception {
        Appointment uApp = new Appointment();
        uApp.setParentFolderID(this.sharedAppointmentFolder.getObjectID());
        uApp.setObjectID(this.appointment.getObjectID());
        uApp.setAlarm(15);
        uApp.setIgnoreConflicts(true);
        uApp.setTitle(this.appointment.getTitle());
        uApp.setStartDate(this.appointment.getStartDate());
        uApp.setEndDate(this.appointment.getEndDate());
        uApp.setLastModified(this.appointment.getLastModified());
        UpdateRequest reminderAppointmentReq = new UpdateRequest(uApp, this.tz, false);
        UpdateResponse reminderAppointmentResp = this.client3.execute(reminderAppointmentReq);
        reminderAppointmentResp.fillObject((DataObject)this.appointment);
        this.appointment.setParentFolderID(this.personalAppointmentFolder.getObjectID());
        UpdateRequest moveAppointmentReq = new UpdateRequest(this.sharedAppointmentFolder.getObjectID(), this.appointment, this.tz, false);
        UpdateResponse moveAppointmentResp = this.client.execute(moveAppointmentReq);
        moveAppointmentResp.fillObject((DataObject)this.appointment);
        GetRequest getAppointmentReq = new GetRequest(this.appointment, false);
        GetResponse getAppointmentResp = this.client.execute(getAppointmentReq);
        JSONObject respObj = (JSONObject)getAppointmentResp.getData();
        if (respObj == null) {
            Bug16211Test.fail((String)"Appointment wasn't found in folder");
        }
        RangeRequest reminderReq = new RangeRequest(this.appointment.getEndDate());
        ArrayList<ReminderObject> reminderList = new ArrayList<ReminderObject>();
        reminderList.add(ReminderTools.get(this.client2, reminderReq).getReminderByTarget(this.tz, this.appointment.getObjectID()));
        reminderList.add(ReminderTools.get(this.client3, reminderReq).getReminderByTarget(this.tz, this.appointment.getObjectID()));
        for (ReminderObject rem : reminderList) {
            if (rem.getTargetId() != this.appointment.getObjectID()) continue;
            int uid = rem.getUser();
            if (uid == this.client2.getValues().getUserId()) {
                Bug16211Test.assertTrue((String)("Reminder is incorrect after move for User " + uid + "."), (rem.getFolder() == this.client2.getValues().getPrivateAppointmentFolder() ? 1 : 0) != 0);
                continue;
            }
            if (uid != this.client3.getValues().getUserId()) continue;
            Bug16211Test.assertTrue((String)("Reminder is incorrect after move for User " + uid + "."), (rem.getFolder() == this.client3.getValues().getPrivateAppointmentFolder() ? 1 : 0) != 0);
        }
    }

    @Override
    public void tearDown() throws Exception {
        GetRequest toDeleteReq = new GetRequest(this.personalAppointmentFolder.getObjectID(), this.appointment.getObjectID());
        GetResponse toDeleteResp = this.client.execute(toDeleteReq);
        Appointment toDelete = toDeleteResp.getAppointment(this.tz);
        this.client.execute(new com.openexchange.ajax.appointment.action.DeleteRequest(toDelete));
        this.client.execute(new DeleteRequest((API)EnumAPI.OX_NEW, this.personalAppointmentFolder.getObjectID(), new Date()));
        this.client2.execute(new DeleteRequest((API)EnumAPI.OX_NEW, this.sharedAppointmentFolder.getObjectID(), new Date()));
        this.client2.logout();
        super.tearDown();
    }

    private Appointment createAppointment() throws OXException, IOException, SAXException, JSONException {
        Calendar cal = (Calendar)this.calendar.clone();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testBug16211");
        cal.add(5, 1);
        appointmentObj.setStartDate(cal.getTime());
        cal.add(10, 1);
        appointmentObj.setEndDate(cal.getTime());
        appointmentObj.setAlarm(15);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.sharedAppointmentFolder.getObjectID());
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setNote("");
        appointmentObj.setNotification(true);
        appointmentObj.setPrivateFlag(false);
        appointmentObj.setFullTime(false);
        UserParticipant newParticipant = new UserParticipant(this.client2.getValues().getUserId());
        appointmentObj.addParticipant((Participant)newParticipant);
        UserParticipant secondParticipant = new UserParticipant(this.client3.getValues().getUserId());
        appointmentObj.addParticipant((Participant)secondParticipant);
        InsertRequest insReq = new InsertRequest(appointmentObj, this.tz, false);
        AppointmentInsertResponse insResp = this.client2.execute(insReq);
        insResp.fillAppointment(appointmentObj);
        return appointmentObj;
    }
}

