/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.appointment.AbstractAppointmentTest;
import com.openexchange.ajax.appointment.action.AppointmentUpdatesResponse;
import com.openexchange.ajax.framework.AbstractUpdatesRequest;
import com.openexchange.groupware.container.Appointment;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class UpdatesForModifiedAndDeletedTest
extends AbstractAppointmentTest {
    public UpdatesForModifiedAndDeletedTest(String name) {
        super(name);
    }

    public void testUpdatesForModifiedAndDeleted() throws Exception {
        int numberOfAppointments = 8;
        List<Appointment> newAppointments = this.createAndPersistSeveral("testAppointment", 8);
        ArrayList<Appointment> updatedAppointments = new ArrayList<Appointment>(2);
        ArrayList<Integer> expectUpdatedAppointmentIds = new ArrayList<Integer>(2);
        updatedAppointments.add(newAppointments.get(0));
        expectUpdatedAppointmentIds.add(newAppointments.get(0).getObjectID());
        updatedAppointments.add(newAppointments.get(1));
        expectUpdatedAppointmentIds.add(newAppointments.get(1).getObjectID());
        this.updateAppointments(updatedAppointments);
        ArrayList<Appointment> deletedAppointments = new ArrayList<Appointment>(2);
        ArrayList<Integer> expectDeletedAppointmentIds = new ArrayList<Integer>(2);
        deletedAppointments.add(newAppointments.get(2));
        expectDeletedAppointmentIds.add(newAppointments.get(2).getObjectID());
        deletedAppointments.add(newAppointments.get(3));
        expectDeletedAppointmentIds.add(newAppointments.get(3).getObjectID());
        this.deleteAppointments(deletedAppointments);
        Date lastModified = newAppointments.get(7).getLastModified();
        int[] cols = new int[]{1, 200};
        AppointmentUpdatesResponse modifiedAppointmentsResponse = this.listModifiedAppointments(this.appointmentFolderId, cols, lastModified, AbstractUpdatesRequest.Ignore.NONE, false);
        UpdatesForModifiedAndDeletedTest.assertTrue((boolean)modifiedAppointmentsResponse.getNewOrModifiedIds().containsAll(expectUpdatedAppointmentIds));
        UpdatesForModifiedAndDeletedTest.assertTrue((boolean)modifiedAppointmentsResponse.getDeletedIds().containsAll(expectDeletedAppointmentIds));
        newAppointments.removeAll(deletedAppointments);
        this.deleteAppointments(newAppointments);
    }
}

