/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.java.util.TimeZones;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class AllTest
extends AppointmentTest {
    private static final Logger LOG = LoggerFactory.getLogger(AllTest.class);
    private static final int[] SIMPLE_COLUMNS = new int[]{1, 20, 200, 201, 202};

    public AllTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.clean();
    }

    public void testShouldListAppointmentsInPrivateFolder() throws Exception {
        Appointment appointment = new Appointment();
        appointment.setStartDate(TimeTools.D("24/02/1998 12:00"));
        appointment.setEndDate(TimeTools.D("24/02/1998 14:00"));
        appointment.setTitle("Appointment 1 for All Test");
        appointment.setParentFolderID(appointmentFolderId);
        this.create(appointment);
        Appointment anotherAppointment = new Appointment();
        anotherAppointment.setStartDate(TimeTools.D("03/05/1999 10:00"));
        anotherAppointment.setEndDate(TimeTools.D("03/05/1999 10:30"));
        anotherAppointment.setTitle("Appointment 2 for All Test");
        anotherAppointment.setParentFolderID(appointmentFolderId);
        this.create(anotherAppointment);
        AllRequest all = new AllRequest(appointmentFolderId, SIMPLE_COLUMNS, TimeTools.D("01/01/1990 00:00"), TimeTools.D("01/01/2000 00:00"), TimeZones.UTC);
        CommonAllResponse allResponse = this.getClient().execute(all);
        JSONArray data = (JSONArray)allResponse.getData();
        this.assertInResponse(data, appointment, anotherAppointment);
        all = new AllRequest(appointmentFolderId, SIMPLE_COLUMNS, TimeTools.D("01/01/1990 00:00"), TimeTools.D("01/01/2000 00:00"), TimeZones.UTC);
        TimeZone respTimeZone = TimeZone.getTimeZone("GMT+08:00");
        all.setTimeZoneId(respTimeZone.getID());
        allResponse = this.getClient().execute(all);
        JSONArray data2 = (JSONArray)allResponse.getData();
        int size = data.length();
        for (int i = 0; i < size; ++i) {
            JSONArray row = data.getJSONArray(i);
            int id = row.getInt(0);
            int folderId = row.getInt(1);
            String title = row.getString(2);
            long startDate = row.getLong(3);
            long endDate = row.getLong(4);
            JSONArray row2 = data2.getJSONArray(i);
            int id2 = row2.getInt(0);
            int folderId2 = row2.getInt(1);
            String title2 = row2.getString(2);
            long startDate2 = row2.getLong(3);
            long endDate2 = row2.getLong(4);
            AllTest.assertEquals((String)"Unexpected ID.", (int)id, (int)id2);
            AllTest.assertEquals((String)"Unexpected folder ID.", (int)folderId, (int)folderId2);
            AllTest.assertEquals((String)"Unexpected title.", (String)title, (String)title2);
            long userTZStartOffset = this.timeZone.getOffset(startDate);
            long respTZStartOffset = respTimeZone.getOffset(startDate);
            AllTest.assertEquals((String)"Unexpected time zone is response", (long)(startDate2 - startDate), (long)(respTZStartOffset - userTZStartOffset));
            long userTZEndOffset = this.timeZone.getOffset(endDate);
            long respTZEndOffset = respTimeZone.getOffset(endDate2);
            AllTest.assertEquals((String)"Unexpected time zone is response", (long)(endDate2 - endDate), (long)(respTZEndOffset - userTZEndOffset));
        }
    }

    public void testShouldOnlyListAppointmentsInSpecifiedTimeRange() throws JSONException, OXException, IOException, SAXException {
        Appointment appointment = new Appointment();
        appointment.setStartDate(TimeTools.D("24/02/1998 12:00"));
        appointment.setEndDate(TimeTools.D("24/02/1998 14:00"));
        appointment.setTitle("Appointment 1 for All Test");
        appointment.setParentFolderID(appointmentFolderId);
        this.create(appointment);
        Appointment anotherAppointment = new Appointment();
        anotherAppointment.setStartDate(TimeTools.D("03/05/1999 10:00"));
        anotherAppointment.setEndDate(TimeTools.D("03/05/1999 10:30"));
        anotherAppointment.setTitle("Appointment 2 for All Test");
        anotherAppointment.setParentFolderID(appointmentFolderId);
        this.create(anotherAppointment);
        AllRequest all = new AllRequest(appointmentFolderId, SIMPLE_COLUMNS, TimeTools.D("01/01/1999 00:00"), TimeTools.D("01/01/2000 00:00"), TimeZones.UTC);
        CommonAllResponse allResponse = this.getClient().execute(all);
        JSONArray data = (JSONArray)allResponse.getData();
        this.assertNotInResponse(data, appointment);
        this.assertInResponse(data, anotherAppointment);
    }

    private void assertInResponse(JSONArray data, Appointment ... appointments) throws JSONException {
        HashSet<Integer> expectedIds = new HashSet<Integer>();
        HashMap<Integer, Appointment> id2appointment = new HashMap<Integer, Appointment>();
        for (Appointment appointment : appointments) {
            expectedIds.add(appointment.getObjectID());
            id2appointment.put(appointment.getObjectID(), appointment);
        }
        int size = data.length();
        for (int i = 0; i < size; ++i) {
            JSONArray row = data.getJSONArray(i);
            int id = row.getInt(0);
            int folderId = row.getInt(1);
            String title = row.getString(2);
            long startDate = row.getLong(3);
            long endDate = row.getLong(4);
            Appointment expectedAppointment = (Appointment)id2appointment.get(id);
            expectedIds.remove(id);
            if (expectedAppointment == null) continue;
            AllTest.assertEquals((int)folderId, (int)expectedAppointment.getParentFolderID());
            AllTest.assertEquals((String)title, (String)expectedAppointment.getTitle());
            AllTest.assertEquals((long)startDate, (long)expectedAppointment.getStartDate().getTime());
            AllTest.assertEquals((long)endDate, (long)expectedAppointment.getEndDate().getTime());
        }
        AllTest.assertTrue((String)("Missing ids: " + expectedIds), (boolean)expectedIds.isEmpty());
    }

    private void assertNotInResponse(JSONArray data, Appointment ... appointments) throws JSONException {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Appointment appointment : appointments) {
            ids.add(appointment.getObjectID());
        }
        int size = data.length();
        for (int i = 0; i < size; ++i) {
            JSONArray row = data.getJSONArray(i);
            int id = row.getInt(0);
            AllTest.assertFalse((boolean)ids.contains(id));
        }
    }

    public void testShowAppointmentsBetween() throws Exception {
        Date start = new Date(System.currentTimeMillis() - 604800000L);
        Date end = new Date(System.currentTimeMillis() + 604800000L);
        int[] cols = new int[]{1};
        AllTest.listAppointment(this.getWebConversation(), appointmentFolderId, cols, start, end, this.timeZone, false, "http://" + this.getHostName(), this.getSessionId());
    }

    public void testShowAllAppointmentWhereIAmParticipant() throws Exception {
        Date start = new Date(System.currentTimeMillis() - 604800000L);
        Date end = new Date(System.currentTimeMillis() + 604800000L);
        int[] cols = new int[]{1};
        AllTest.listAppointment(this.getWebConversation(), appointmentFolderId, cols, start, end, this.timeZone, true, "http://" + this.getHostName(), this.getSessionId());
    }

    public void testShowFullTimeAppointments() throws Exception {
        int a;
        int[] cols = new int[]{1};
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(startTime);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date startDate = calendar.getTime();
        calendar.add(5, 1);
        Date endDate = calendar.getTime();
        Appointment appointmentObj = this.createAppointmentObject("testShowFullTimeAppointments");
        appointmentObj.setStartDate(startDate);
        appointmentObj.setEndDate(endDate);
        appointmentObj.setFullTime(true);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = AllTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(startTime);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date start = calendar.getTime();
        Date end = new Date(start.getTime() + 86400000L);
        Appointment[] appointmentArray = AllTest.listAppointment(this.getWebConversation(), appointmentFolderId, cols, start, end, this.timeZone, false, this.getHostName(), this.getSessionId());
        boolean found = false;
        for (a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            found = true;
        }
        AllTest.assertTrue((String)"appointment not found in day view", (boolean)found);
        start = new Date(calendar.getTimeInMillis() - 86400000L);
        end = new Date(start.getTime() + 86400000L);
        appointmentArray = AllTest.listAppointment(this.getWebConversation(), appointmentFolderId, cols, start, end, this.timeZone, false, this.getHostName(), this.getSessionId());
        found = false;
        for (a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            found = true;
        }
        AllTest.assertFalse((String)"appointment found one day before start date in day view", (boolean)found);
        start = new Date(calendar.getTimeInMillis() + 86400000L);
        end = new Date(start.getTime() + 86400000L);
        appointmentArray = AllTest.listAppointment(this.getWebConversation(), appointmentFolderId, cols, start, end, this.timeZone, false, this.getHostName(), this.getSessionId());
        found = false;
        for (a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            found = true;
        }
        AllTest.assertFalse((String)"appointment found one day after start date in day view", (boolean)found);
        AllTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.getHostName(), this.getSessionId(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShowOcurrences() throws Exception {
        int[] cols = new int[]{1, 222};
        Appointment appointmentObj = this.createAppointmentObject("testShowOcurrences");
        appointmentObj.setStartDate(new Date());
        appointmentObj.setEndDate(new Date(System.currentTimeMillis() + 3600000L));
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setOccurrence(3);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = -1;
        try {
            Appointment[] appointmentArray;
            objectId = AllTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
            for (Appointment loaded : appointmentArray = AllTest.listAppointment(this.getWebConversation(), appointmentFolderId, cols, new Date(0L), new Date(Long.MAX_VALUE), this.timeZone, false, this.getHostName(), this.getSessionId())) {
                if (loaded.getObjectID() != objectId) continue;
                AllTest.assertEquals((int)appointmentObj.getOccurrence(), (int)loaded.getOccurrence());
            }
        }
        finally {
            if (objectId != -1) {
                AllTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.getHostName(), this.getSessionId(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLastModifiedUTC() throws Exception {
        AJAXClient client = new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId()), false);
        int[] cols = new int[]{1, 20, 6};
        Appointment appointmentObj = this.createAppointmentObject("testShowLastModifiedUTC");
        appointmentObj.setStartDate(new Date());
        appointmentObj.setEndDate(new Date(System.currentTimeMillis() + 3600000L));
        appointmentObj.setIgnoreConflicts(true);
        int objectId = AllTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, this.getHostName(), this.getSessionId());
        try {
            AllRequest req = new AllRequest(appointmentFolderId, cols, new Date(0L), new Date(Long.MAX_VALUE), TimeZone.getTimeZone("UTC"));
            CommonAllResponse response = Executor.execute(client, req);
            JSONArray arr = (JSONArray)response.getResponse().getData();
            AllTest.assertNotNull((Object)arr);
            int size = arr.length();
            AllTest.assertTrue((size > 0 ? 1 : 0) != 0);
            for (int i = 0; i < size; ++i) {
                JSONArray objectData = arr.optJSONArray(i);
                AllTest.assertNotNull((Object)objectData);
                AllTest.assertNotNull((Object)objectData.opt(2));
            }
        }
        finally {
            AllTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.getHostName(), this.getSessionId(), false);
        }
    }
}

