/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import java.io.File;
import java.io.FileDescriptor;
import java.util.StringTokenizer;

public class UNIXFile
extends File {
    protected static final boolean loaded;
    protected static final int lockType;
    private static final long serialVersionUID = -7972156315284146651L;
    protected static final int NONE = 0;
    protected static final int NATIVE = 1;
    protected static final int JAVA = 2;

    public UNIXFile(String name) {
        super(name);
    }

    public static long lastAccessed(File file) {
        return UNIXFile.lastAccessed0(file.getPath());
    }

    public long lastAccessed() {
        return UNIXFile.lastAccessed0(this.getPath());
    }

    private static native void initIDs(Class var0, FileDescriptor var1);

    public static boolean lock(FileDescriptor fd, String mode) {
        return UNIXFile.lock(fd, mode, false);
    }

    private static boolean lock(FileDescriptor fd, String mode, boolean block) {
        if (loaded) {
            boolean ret = UNIXFile.lock0(fd, mode, block);
            return ret;
        }
        return false;
    }

    private static native boolean lock0(FileDescriptor var0, String var1, boolean var2);

    public static native long lastAccessed0(String var0);

    static {
        String lt = System.getProperty("mail.mbox.locktype", "native");
        int type = 1;
        if (lt.equalsIgnoreCase("none")) {
            type = 0;
        } else if (lt.equalsIgnoreCase("java")) {
            type = 2;
        }
        lockType = type;
        boolean lloaded = false;
        if (lockType == 1) {
            try {
                System.loadLibrary("mbox");
                lloaded = true;
            }
            catch (UnsatisfiedLinkError e) {
                String classpath = System.getProperty("java.class.path");
                String sep = System.getProperty("path.separator");
                String arch = System.getProperty("os.arch");
                StringTokenizer st = new StringTokenizer(classpath, sep);
                while (st.hasMoreTokens()) {
                    String path = st.nextToken();
                    if (!path.endsWith("/classes") && !path.endsWith("/mail.jar") && !path.endsWith("/javax.mail.jar")) continue;
                    int i = path.lastIndexOf(47);
                    String libdir = path.substring(0, i + 1) + "lib/";
                    String lib = libdir + arch + "/libmbox.so";
                    try {
                        System.load(lib);
                        lloaded = true;
                        break;
                    }
                    catch (UnsatisfiedLinkError e2) {
                        lib = libdir + "libmbox.so";
                        try {
                            System.load(lib);
                            lloaded = true;
                            break;
                        }
                        catch (UnsatisfiedLinkError e3) {
                        }
                    }
                }
            }
        }
        if (loaded = lloaded) {
            UNIXFile.initIDs(FileDescriptor.class, FileDescriptor.in);
        }
    }
}

