/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import com.openexchange.config.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPoolProperties {
    private int corePoolSize;
    private boolean prestartAllCoreThreads;
    private int maximumPoolSize;
    private long keepAliveTime;
    private String workQueue;
    private int workQueueSize;
    private String refusedExecutionBehavior;
    private boolean blocking;

    public ThreadPoolProperties init(ConfigurationService configurationService) {
        if (null != configurationService) {
            this.corePoolSize = 3;
            String tmp = configurationService.getProperty("com.openexchange.threadpool.corePoolSize");
            if (null != tmp) {
                try {
                    this.corePoolSize = Integer.parseInt(tmp.trim());
                }
                catch (NumberFormatException e) {
                    this.corePoolSize = 3;
                }
            }
            this.prestartAllCoreThreads = true;
            tmp = configurationService.getProperty("com.openexchange.threadpool.prestartAllCoreThreads");
            if (null != tmp) {
                this.prestartAllCoreThreads = Boolean.parseBoolean(tmp.trim());
            }
            this.maximumPoolSize = Integer.MAX_VALUE;
            tmp = configurationService.getProperty("com.openexchange.threadpool.maximumPoolSize");
            if (null != tmp) {
                try {
                    this.maximumPoolSize = Integer.parseInt(tmp.trim());
                }
                catch (NumberFormatException e) {
                    this.maximumPoolSize = Integer.MAX_VALUE;
                }
            }
            this.keepAliveTime = 60000L;
            tmp = configurationService.getProperty("com.openexchange.threadpool.keepAliveTime");
            if (null != tmp) {
                try {
                    this.keepAliveTime = Long.parseLong(tmp.trim());
                }
                catch (NumberFormatException e) {
                    this.keepAliveTime = 60000L;
                }
            }
            this.workQueueSize = 0;
            tmp = configurationService.getProperty("com.openexchange.threadpool.workQueueSize");
            if (null != tmp) {
                try {
                    this.workQueueSize = Integer.parseInt(tmp.trim());
                }
                catch (NumberFormatException e) {
                    this.workQueueSize = 0;
                }
            }
            if (this.workQueueSize <= 0) {
                this.workQueue = "synchronous";
                tmp = configurationService.getProperty("com.openexchange.threadpool.workQueue");
                if (null != tmp) {
                    this.workQueue = tmp.trim();
                }
            } else {
                this.workQueue = "linked";
            }
            this.blocking = false;
            tmp = configurationService.getProperty("com.openexchange.threadpool.blocking");
            if (null != tmp) {
                try {
                    this.blocking = Boolean.parseBoolean(tmp.trim());
                }
                catch (NumberFormatException e) {
                    this.blocking = false;
                }
            }
            this.refusedExecutionBehavior = "abort";
            tmp = configurationService.getProperty("com.openexchange.threadpool.refusedExecutionBehavior");
            if (null != tmp) {
                this.refusedExecutionBehavior = tmp.trim();
            }
        } else {
            this.corePoolSize = 3;
            this.prestartAllCoreThreads = true;
            this.maximumPoolSize = Integer.MAX_VALUE;
            this.keepAliveTime = 60000L;
            this.workQueue = "synchronous";
            this.refusedExecutionBehavior = "abort";
        }
        Logger LOG = LoggerFactory.getLogger(ThreadPoolProperties.class);
        String ls = System.getProperty("line.separator");
        LOG.info("Thread Pool Configuration:\n\tcorePoolSize={}{}\tprestartAllCoreThreads={}{}\tkeepAliveTime={}sec{}\tworkQueue={}{}\trefusedExecutionBehavior={}", new Object[]{this.corePoolSize, ls, this.prestartAllCoreThreads, ls, this.keepAliveTime, ls, this.workQueue, ls, this.refusedExecutionBehavior});
        return this;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean isPrestartAllCoreThreads() {
        return this.prestartAllCoreThreads;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public String getWorkQueue() {
        return this.workQueue;
    }

    public int getWorkQueueSize() {
        return this.workQueueSize;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public String getRefusedExecutionBehavior() {
        return this.refusedExecutionBehavior;
    }
}

