/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.internal;

import com.openexchange.threadpool.internal.CustomThreadPoolExecutor;
import java.util.concurrent.RejectedExecutionHandler;

public enum RejectedExecutionType {
    ABORT("abort", new CustomThreadPoolExecutor.AbortPolicy()),
    CALLER_RUNS("caller-runs", new CustomThreadPoolExecutor.CallerRunsPolicy()),
    DISCARD("discard", new CustomThreadPoolExecutor.DiscardPolicy());

    private final String identifier;
    private final RejectedExecutionHandler handler;

    private RejectedExecutionType(String identifier, RejectedExecutionHandler handler) {
        this.identifier = identifier;
        this.handler = handler;
    }

    public RejectedExecutionHandler getHandler() {
        return this.handler;
    }

    public static RejectedExecutionType getRejectedExecutionType(String identifier) {
        RejectedExecutionType[] types;
        for (RejectedExecutionType rejectedExecutionType : types = RejectedExecutionType.values()) {
            if (!rejectedExecutionType.identifier.equalsIgnoreCase(identifier)) continue;
            return rejectedExecutionType;
        }
        return null;
    }
}

