/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.contact.ContactService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.generic.TargetFolderDefinition;
import com.openexchange.groupware.tools.mappings.MappedTruncation;
import com.openexchange.java.Autoboxing;
import com.openexchange.session.Session;
import com.openexchange.subscribe.TargetFolderSession;
import com.openexchange.subscribe.internal.FolderUpdaterStrategy;
import com.openexchange.subscribe.osgi.SubscriptionServiceRegistry;
import com.openexchange.tools.arrays.Arrays;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactFolderUpdaterStrategy
implements FolderUpdaterStrategy<Contact> {
    private static final Logger LOG = LoggerFactory.getLogger(ContactFolderUpdaterStrategy.class);
    private static final int SQL_INTERFACE = 1;
    private static final int TARGET = 2;
    private static final int SESSION = 3;
    private static final ContactField[] COMPARISON_FIELDS = new ContactField[]{ContactField.OBJECT_ID, ContactField.FOLDER_ID, ContactField.GIVEN_NAME, ContactField.SUR_NAME, ContactField.BIRTHDAY, ContactField.DISPLAY_NAME, ContactField.EMAIL1, ContactField.EMAIL2, ContactField.EMAIL3, ContactField.USERFIELD20};
    private static final int[] MATCH_COLUMNS = Autoboxing.I2i((Integer[])((Integer[])Arrays.remove((Object[])Autoboxing.i2I((int[])Contact.CONTENT_COLUMNS), (Object[])new Integer[]{Autoboxing.I((int)590)})));

    @Override
    public int calculateSimilarityScore(Contact original, Contact candidate, Object session) {
        int score = 0;
        int threshold = this.getThreshold(session);
        if (this.isReasonablyEmpty(original) && this.isReasonablyEmpty(candidate)) {
            return threshold + 1;
        }
        if ((this.isset(original.getGivenName()) || this.isset(candidate.getGivenName())) && this.eq(original.getGivenName(), candidate.getGivenName())) {
            score += 5;
        }
        if ((this.isset(original.getSurName()) || this.isset(candidate.getSurName())) && this.eq(original.getSurName(), candidate.getSurName())) {
            score += 5;
        }
        if ((this.isset(original.getDisplayName()) || this.isset(candidate.getDisplayName())) && this.eq(original.getDisplayName(), candidate.getDisplayName())) {
            score += 10;
        }
        if (this.eq(original.getEmail1(), candidate.getEmail1())) {
            score += 10;
        }
        if (this.eq(original.getEmail2(), candidate.getEmail2())) {
            score += 10;
        }
        if (this.eq(original.getEmail3(), candidate.getEmail3())) {
            score += 10;
        }
        if (original.containsBirthday() && candidate.containsBirthday() && this.eq(original.getBirthday(), candidate.getBirthday())) {
            score += 5;
        }
        if (score < threshold && original.matches(candidate, MATCH_COLUMNS)) {
            score = threshold + 1;
        }
        return score;
    }

    private boolean isReasonablyEmpty(Contact c) {
        return !c.containsEmail1() && !c.containsEmail2() && !c.containsEmail3() && !c.containsSurName() && !c.containsGivenName() && !c.containsYomiFirstName() && !c.containsYomiLastName() && !c.containsCompany() && !c.containsYomiCompany() && !c.containsDisplayName() && !c.containsNickname();
    }

    private boolean isset(String s) {
        return s == null || s.length() > 0;
    }

    protected boolean eq(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    public void closeSession(Object session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Contact> getData(TargetFolderDefinition target, Object session) throws OXException {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        Object sqlInterface = this.getFromSession(1, session);
        Object targetFolderSession = this.getFromSession(3, session);
        if (sqlInterface instanceof ContactService && targetFolderSession instanceof TargetFolderSession) {
            SearchIterator searchIterator = null;
            try {
                searchIterator = ((ContactService)sqlInterface).getAllContacts((Session)((TargetFolderSession)targetFolderSession), target.getFolderId(), COMPARISON_FIELDS);
                if (null != searchIterator) {
                    while (searchIterator.hasNext()) {
                        contacts.add((Contact)searchIterator.next());
                    }
                }
            }
            finally {
                if (null != searchIterator) {
                    searchIterator.close();
                }
            }
        }
        return contacts;
    }

    @Override
    public int getThreshold(Object session) {
        return 9;
    }

    @Override
    public boolean handles(FolderObject folder) {
        return folder.getModule() == 3;
    }

    @Override
    public void save(Contact newElement, Object session) throws OXException {
        Object sqlInterface = this.getFromSession(1, session);
        Object targetFolderSession = this.getFromSession(3, session);
        if (sqlInterface instanceof ContactService && targetFolderSession instanceof TargetFolderSession) {
            TargetFolderDefinition target = (TargetFolderDefinition)this.getFromSession(2, session);
            newElement.setParentFolderID(target.getFolderIdAsInt());
            try {
                ((ContactService)sqlInterface).createContact((Session)((TargetFolderSession)targetFolderSession), target.getFolderId(), newElement);
            }
            catch (OXException e) {
                if (ContactExceptionCodes.DATA_TRUNCATION.equals(e)) {
                    boolean hasTrimmed = false;
                    try {
                        hasTrimmed = MappedTruncation.truncate((OXException.ProblematicAttribute[])e.getProblematics(), (Object)newElement);
                    }
                    catch (OXException x) {
                        LOG.warn("error trying to handle truncated attributes", (Throwable)x);
                    }
                    if (hasTrimmed) {
                        this.save(newElement, session);
                        return;
                    }
                }
                throw e;
            }
        }
    }

    private Object getFromSession(int key, Object session) {
        return ((Map)session).get(key);
    }

    @Override
    public Object startSession(TargetFolderDefinition target) throws OXException {
        HashMap<Integer, Object> userInfo = new HashMap<Integer, Object>();
        TargetFolderSession session = new TargetFolderSession(target);
        ContactService contactService = (ContactService)SubscriptionServiceRegistry.getInstance().getService(ContactService.class);
        userInfo.put(1, contactService);
        userInfo.put(2, target);
        userInfo.put(3, session);
        return userInfo;
    }

    @Override
    public void update(Contact original, Contact update, Object session) throws OXException {
        Object sqlInterface = this.getFromSession(1, session);
        Object targetFolderSession = this.getFromSession(3, session);
        if (sqlInterface instanceof ContactService && targetFolderSession instanceof TargetFolderSession) {
            update.setParentFolderID(original.getParentFolderID());
            update.setObjectID(original.getObjectID());
            update.setLastModified(new Date(System.currentTimeMillis()));
            update.setUserField20(original.getUserField20());
            ((ContactService)sqlInterface).updateContact((Session)((TargetFolderSession)targetFolderSession), String.valueOf(update.getParentFolderID()), String.valueOf(update.getObjectID()), update, update.getLastModified());
        }
    }
}

